<?php

namespace Wizkch\Formtest\Tests\Browser;

use Exception;

trait FillForm
{
	// const DATA_FILE_NAME = "your_data.csv";

	public function getDataPath()
	{
		if (! defined('static::DATA_FILE_NAME')) {
			throw new Exception("シードデータのファイル名を指定してください");
		}
		return static::DATA_FILE_NAME;
	}

	/**
	 * 指定CSVから設定を読み込む
	 *
	 * @return void
	 */
	protected function inputs()
	{
		$fp = fopen(base_path("tests/Browser/form_seeds/" . $this->getDataPath()), "r");
		$list = [];
		$i = 0;

		$names = [];
		$types = [];
		while (($data = fgetcsv($fp, 0, ",")) !== false) {
			foreach ($data as $n => $v) {
				if ($n === 0) {
					continue;
				}

				if ($i === 0) {
					if (strpos($v, ":") === false) {
						throw new Exception(":でタイプを指定してください");
					}
					else {
						list($name, $type) = explode(":", $v);
						if (! in_array($type, ['text', 'textarea', 'tel', 'url', 'file', 'email', 'radio', 'checkbox', 'select', 'password'])) {
							throw new Exception("タイプが存在しません");
						}
						$names[$n] = $name;
						$types[$n] = $type;
					}
				}
				else {
					$list[$data[0]][$names[$n]] = ['type' => $types[$n], 'value' => $v];
				}
			}
			$i ++;
		}

		return $list;
	}

	/**
	 * フォームの入力内容をチェックする
	 *
	 * @param Laravel\Dusk\Browser $browser
	 * @param string $key 使用するデータセットの名称
	 * @return void
	 */
    public function fillForm($browser, $key = "")
    {
		if (empty($key)) {
			return null;
		}

		$data = collect($this->inputs())->get($key);

		if (empty($data)) {
			return null;
		}

        collect($data)->each(function ($config, $name) use ($browser, $key) {
			try {
				$browser->ensurejQueryIsAvailable();
				$value = $config['value'];
				// ラジオ、チェックボックス、セレクトボタンはデザイン上hidden状態になってるとデフォルトメソッドで捕捉できないのでJSで
				switch($config['type']) {
					case 'radio':
						if (!empty($value)) {
							$browser->script("$(\"input[name='{$name}'][value='{$value}']\").click()");
						}
						break;
					case 'checkbox':
						if (!empty($value)) {
							$_vs = explode("&", $value);
							foreach ($_vs as $i => $v) {
								$browser->script("$(\"input[name='{$name}'][value='{$v}']\").click()");
							}
						}
						break;
					case 'select':
						if (!empty($value)) {
							$browser->script("$(\"[name='{$name}']\").val('{$value}').change()");
						}
						break;
					case 'file':
						$browser->attach($name, base_path('tests/Browser/form_seeds/test.png'));
						break;
					default:
						$browser->script("$(\"[name='{$name}']\").val('{$value}').blur()");
						break;
				}
			} catch (\Throwable $th) {
				dd($th->getMessage());
			}
		});

		return $data;
    }
}