# Laravel Dusk用 フォーム入力補完パッケージ

```
composer require --dev wizkch/formtest
```

## チュートリアル：パッケージの利用方法

### 1. 既存のフォーム（ローカル / リモート）からインプットフィールドを検知

例）phpコンテナの /formページのform#formのインプットを探索しform_testというファイル名で保存する
※tests/form_seeds/ に保存される
※form_test.csv.sampleで保存されるので.sampleは削る

```
docker exec -it formtest php artisan test:pick_up_form_fields -c php -u form -e form -o form_test
```

オプションの説明は、以下で確認

```
docker exec -it formtest php artisan test:pick_up_form_fields -h
```

### 2. 検知結果のCSVにテストデータを入力する
form_test.csv.sampleには、すでに「正常系」としてデータ入力サンプルが一行登録されている

|フィールド|name:text|email:email|type:radio|genre:select|categories[]:checkbox|content:textarea|
|--|--|--|--|--|--|--|
|正常系|テスト|test@012grp.jp|1|1|1&2|テスト\nテスト|

行をコピーして、テストに必要なデータを作る
例）名前が空白

|フィールド|name:text|email:email|type:radio|genre:select|categories[]:checkbox|content:textarea|
|--|--|--|--|--|--|--|
|正常系|テスト|test@012grp.jp|1|1|1&2|テスト\nテスト|
|名前が空白||test@012grp.jp|1|1|1&2|テスト\nテスト|

### 3. 適当なテストを作る

```
docker exec -it formtest php artisan dusk:make FormTest
```

### 4. 3のテスト内で以下の設定をし、2のCSVを3のテストで利用するようにする
cf）tests/Browser/SampleFromTest.php

1. tests/Browser/FormTest.php内で、FillFormトレイトを利用
2. const DATA_FILE_NAME を指定
3. CSV内の参照したいデータキーを指定し、fillForm() 呼び出す（実際の入力データが返ってくる）

```
<?php

namespace Tests\Browser;

use Wizkch\Formtest\Tests\Browser\FillForm;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class FormTest extends DuskTestCase
{
    use FillForm;

    const DATA_FILE_NAME = 'form_test.csv';
```

### 5. 4に適当なテストを書いてみる
今回のフォームには、エラー表示要素のクラスに[data-field='{name}']が含まれる前提
Laravelのエラー表示部はバックエンドが担当だと思うので上記のような属性つけておくようにするとテストで捕捉しやすい

```
<?php

namespace Tests\Browser;

use Wizkch\Formtest\Tests\Browser\FillForm;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class FormTest extends DuskTestCase
{
    use FillForm;

    const DATA_FILE_NAME = 'form_test.csv';

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test正常系()
    {
        $this->browse(function (Browser $browser) {
            $browser->visit('/form');

            $this->fillForm($browser, '正常系');

            $browser
                ->screenshot('form_正常系_投稿前')
                ->press('送信')
                ->assertSee('投稿完了')
                ->screenshot('form_正常系_投稿後');
        });
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test名前が空白のときエラー表示される()
    {
        $this->browse(function (Browser $browser) {
            $browser->visit('/form');

            $this->fillForm($browser, '名前が空白');

            $browser
                ->screenshot('form_名前が空白_投稿前')
                ->press('送信')
                ->assertDontSee('投稿完了')
                ->assertVisible("[data-field='name']")
                ->assertMissing("[data-field='email']")
                ->assertMissing("[data-field='type']")
                ->assertMissing("[data-field='genre']")
                ->assertMissing("[data-field='categories[]']")
                ->assertMissing("[data-field='content']")
                ->screenshot('form_名前が空白_投稿後');
        });
    }
```

### 6. 5のテストを実行する
```
docker exec -it formtest vendor/bin/phpunit tests/Browser/FormTest.php
```

※実際の動作サンプルはリポジトリformtest-playground 参照

[formtest-playground(bitbucket)](bitbucket.org/w012/formtest-playground/)
