<?php

namespace Wizkch\Formtest\Console\Commands;

use Illuminate\Console\Command;
use GuzzleHttp\Client;
use \DOMXPath;
use \DOMDocument;
use Illuminate\Support\Facades\File;

class PickUpFormFields extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:pick_up_form_fields {--u|url= : 探索したいURL（絶対URLと相対URL、いずれも指定可）} {--c|container= : ローカル、docker開発時のwebコンテナ名} {--o|out= : 保存CSV名 保存先ディレクトリ：（tests/Browser/form_seeds/）} {--e|element= : 探索したいformを指し示す要素（現在、idのみ想定）　指定ない場合、ページ中の最初のformを探索}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'テストするフォームの入力フィールドを抽出する';

    private static $values = [
        'text' => 'テスト',
        'textarea' => 'テスト\nテスト',
        'tel' => '000-1111-2222',
        'url' => 'http://test.jp',
        'file' => '',
        'email' => 'test@012grp.jp',
        'radio' => '1',
        'checkbox' => '1&2',
        'select' => '1',
        'password' => 'passw0rd',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (!$name = $this->option('out')) {
            $this->error('ファイル名を指定してください');
            exit;
        }

        if (!$url = $this->option('url')) {
            $this->error('URLを指定してください');
            exit;
        }

        try {
            // 相対URL
            if (! preg_match("/https?:\/\//", $url)) {
                if ($container = $this->option('container')) {
                    $_url = "{$container}/{$url}";
                }
                else {
                    $_url = "localhost/{$url}";
                }
                $url = "http://" . str_replace("//", "/", $_url);
            }

            $client = new Client;
            $response = $client->get($url);

            $html = (string) $response->getBody();

            $dom = new DOMDocument;
            @$dom->loadHTML($html);

            $xpath = new DOMXPath($dom);
            $xpath->registerNamespace("php", "http://php.net/xpath");
            $xpath->registerPHPFunctions();

            if (!$element = $this->option('element')) {
                $form = $dom->getElementsByTagName('form')->item(0);
            }
            // いったんID想定
            else {
                $form = $dom->getElementById($element);
            }

            $inputs = ['フィールド'];
            $values = ['正常系'];

            $elements = $xpath->query('.//input | .//textarea | .//select', $form);
            foreach ($elements as $n => $element) {
                if ($element->getAttribute('type') === 'hidden' || $element->getAttribute('type') === 'submit') {
                    continue;
                }
                $type = $element->nodeName === 'input' ? $element->getAttribute('type') : $element->nodeName;

                $input = $element->getAttribute('name') . ':' . $type;
                if (in_array($input, $inputs)) {
                    continue;
                }

                $inputs[] = $input;
                $values[] = self::$values[$type];
            }

            $dir = base_path("tests/Browser/form_seeds");
            if (!File::exists($dir)) {
                File::makeDirectory($dir);
            }
            $fp = fopen("{$dir}/{$name}.csv.sample", 'w');

            fputcsv($fp, $inputs);
            fputcsv($fp, $values);
        } catch (\Throwable $th) {
            $this->error($th->getMessage());
        }
    }
}
