<?php
use Cake\Routing\Router;

Router::plugin('StaticPages', function ($routes) {
    $routes->fallbacks('InflectedRoute');
});

// $_SERVER['REQUEST_URI']を見て、該当するDocumentRoot上の
// ディレクトリ/ファイルが存在する場合routing実行
if (!empty($_SERVER['REQUEST_URI'])) {

    // $_SERVER['REQUEST_URI']を分解
    $paths = explode(DIRECTORY_SEPARATOR, $_SERVER['REQUEST_URI']);
    // CTODO: WEBROOT_DIRがないのでどうしようか検討中
    // WEBROOT_DIRは削除(サブディレクトリにcakeおいている場合のサブディレクトリ名)
    // $subdirIndex = array_search(WEBROOT_DIR, $paths);
    // if($subdirIndex >= 0) {
    //     for ($i = 0; $i <= $subdirIndex; $i++) {
    //         unset($paths[$i]);
    //     }
    // }
    // 空要素を削除
    $paths = array_filter($paths);
    // ?、:といったパラメータを含む場合除外(このプラグインでは考慮しない)
    foreach ($paths as $key => $path) if(preg_match("/\?|:/", $path)) unset($paths[$key]);
    // keyを連番に
    $paths = array_values($paths);

    // リクエストされたであろう.ctpファイルを指定
    $template = WWW_ROOT;
    if (count($paths) > 0) {
        // $pathsの末尾の要素からファイル指定orディレクトリ指定かを判断
        $last = $paths[count($paths) - 1];
        // last以外のパスは$templateに含めておく
        unset($paths[count($paths) - 1]);
        if (count($paths) > 0) $template .= implode(DIRECTORY_SEPARATOR, $paths) . DIRECTORY_SEPARATOR;

        // dotを含む=拡張子を含む場合、拡張子をctpに変換
        if (preg_match("/\./", $last)) {
            $last = preg_replace("/\..+$/", '.ctp', $last);
            $template .= $last;
        } else {
            // そうでない場合、ディレクトリの有無によって判断
            // $lastという名のディレクトリが存在する場合、$last/index.ctpを指定
            if(file_exists($template . DIRECTORY_SEPARATOR . $last) && is_dir($template . DIRECTORY_SEPARATOR . $last)){
                $template .= $last . DIRECTORY_SEPARATOR . 'index.ctp';
            } else {
                // 存在しない場合$last.ctpを指定
                $template .= "{$last}.ctp";
            }
        }
    } else {
        // DocumentRoot直下のindex.ctp or {$prefix}_index.ctpを指定
        $template .= 'index.ctp';
    }

    // $templateファイルが存在する場合、Routing登録
    if (file_exists($template)) {
        $options = [
            'plugin'        => 'StaticPages',
            'controller'    => 'StaticPages',
            'action'        => 'index',
            'template'      => $template,
        ];

        Router::connect($_SERVER['REQUEST_URI'], $options);
    }

}
// $_SERVER['REQUEST_URI']が存在しない場合そのまま終了(not found)