<?php
namespace StaticPages\View;

use Cake\View\View;
use Cake\View\Exception\MissingTemplateException;

/**
 * StaticPageレンダリング用のViewサブクラス
 */
class StaticPagesView extends View
{

    /**
     * Returns filename of given action's template file (.ctp) as a string.
     * CamelCased action names will be under_scored by default.
     * This means that you can have LongActionNames that refer to
     * long_action_names.ctp views. You can change the inflection rule by
     * overriding _inflectViewFileName.
     *
     * @param string|null $name Controller action to find template filename for
     * @return string Template filename
     * @throws \Cake\View\Exception\MissingTemplateException when a view file could not be found.
     */
    protected function _getViewFileName($name = null)
    {
        $templatePath = $subDir = '';

        if ($this->subDir !== null) {
            $subDir = $this->subDir . DIRECTORY_SEPARATOR;
        }
        if ($this->templatePath) {
            $templatePath = $this->templatePath . DIRECTORY_SEPARATOR;
        }

        if ($name === null) {
            $name = $this->template;
        }

        list($plugin, $name) = $this->pluginSplit($name);
        $name = str_replace('/', DIRECTORY_SEPARATOR, $name);

        if (strpos($name, DIRECTORY_SEPARATOR) === false && $name[0] !== '.') {
            $name = $templatePath . $subDir . $this->_inflectViewFileName($name);
        } elseif (strpos($name, DIRECTORY_SEPARATOR) !== false) {
            if ($name[0] === DIRECTORY_SEPARATOR || $name[1] === ':') {
                /**
                 * appディレクトリ外の.ctpファイルもレンダリングできるよう、
                 * 渡されたパスにファイルが存在すればそのままファイル名を返す
                 */
                if (is_file($name)) {
                    return $name;
                }
                $name = trim($name, DIRECTORY_SEPARATOR);
            } elseif (!$plugin || $this->templatePath !== $this->name) {
                $name = $templatePath . $subDir . $name;
            } else {
                $name = DIRECTORY_SEPARATOR . $subDir . $name;
            }
        }

        foreach ($this->_paths($plugin) as $path) {
            if (file_exists($path . $name . $this->_ext)) {
                return $this->_checkFilePath($path . $name . $this->_ext, $path);
            }
        }
        throw new MissingTemplateException(['file' => $name . $this->_ext]);
    }

}
