<?php

namespace StaticPages\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Network\Exception\NotFoundException;

class StaticPagesController extends AppController
{

    //appディレクトリ外のctpファイルをレンダリングするため、独自Viewを指定
    public $viewClass = 'StaticPages.StaticPages';

    /**
     * template
     */
    protected $_template = null;

    /*
     * beforeFilter
     */
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        // template
        if (empty($this->request->params['template'])) {
            throw new NotFoundException();
        }
        $this->_template = $this->request->params['template'];
    }

    /**
     * index
     */
    public function index()
    {
        $this->render($this->_template);
    }

}
