<?php
/**
 * _list.ctp
 *
 * 管理画面一覧(index)に出す一覧tableの中身を指定する
 */
?>

<tr>
	<th>タイトル</th>
	<th class="w200">表示順</th>
	<th class="w200">最終更新日/最終更新者</th>
	<th class="w100">公開/非公開</th>
	<th class="w200">操作</th>
</tr>

<?php if ($datas->count() === 0) : // データなし ?>

	<tr>
		<td id="noData">条件に合うデータがありません</td>
	</tr>

<?php endif; // データ有無判断ここまで ?>

<?php foreach ($datas as $data) : ?>

	<tr>
		<td>
			<?php echo $this->Html->link($data->title, ['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'edit', $data->id]); ?>
		</td>
		<td align="center">
			<?php echo $this->Private->getSequenceInput($data->id, $data->sequence, ['modelName' => $settings['tableName']]); ?>
		</td>
		<td align="center">
			<?php echo $this->Private->getFormatDate('Y/n/j H:i:s', $data->modified); ?>
			<br />
			<?php echo $this->Private->inputUser($data->modified_id); ?>
		</td>
		<td align="center">
			<?php echo $this->Private->selectPublic($data, ['modelName' => $settings['tableName']]); ?>
		</td>
		<td>
			<?php echo $this->Private->getOperationPanel($data->id, ['edit', 'copy', 'delete'], ['plugin' => null, 'controller' => $settings['tableName']]); ?>
		</td>
	</tr>

<?php endforeach; ?>