<?php
	use Cake\Utility\Inflector;
?>

<h1><?php echo $subject; ?>管理</h1>

<?php if ($this->request->action == 'confirm') : // 登録、修正確認画面 ?>
	<h2><?php echo $subject; ?><?php echo (empty($formEntity->id) ? '登録' : '編集'); ?></h2>
	<h3>以下の内容で<?php echo $subject; ?>を更新します<br />よろしければ「完了」を、修正する場合は「戻る」をクリックしてください</h3>
<?php elseif ($this->request->action == 'deleteConfirm') : // 削除確認画面 ?>
	<h3>以下の<?php echo $subject; ?>を削除します<br />よろしければ「完了」を、削除しない場合は「戻る」をクリックしてください</h3>
<?php elseif ($this->request->action == 'show') : // 詳細画面 ?>
	<h2><?php echo $subject; ?>詳細</h2>
<?php endif; // 削除確認画面ここまで ?>

<table class="table table-bordered form">
	<?php if (in_array('_form', $templateFiles)) : ?>
		<?php echo $this->element('..' . DS . 'Admin' . DS . $settings['tableName'] . DS . '_form'); ?>
	<?php else : ?>
		<?php echo $this->element('MasterCrud._form'); ?>
	<?php endif; ?>
</table>

<?php if ($this->request->action == 'confirm') : // 登録、修正確認画面 ?>

	<?php
		echo $this->Form->create($formEntity, ['url' => ['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'add'], 'name' => 'add']);
		echo $this->Form->hidden('formToken', ['value' => $formToken]);
		echo $this->Form->end();
	?>
	<?php
		echo $this->Form->create($formEntity, ['url' => ['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'complete'], 'name' => 'complete']);
		echo $this->Form->hidden('formToken', ['value' => $formToken]);
		echo $this->Form->end();
	?>
	<div>
		<?php echo $this->Html->link('戻る', "javascript:jQuery('form[name=add]').submit();", array('class' => 'btn btn-warning')); ?>
		<?php echo $this->Html->link('完了', "javascript:jQuery('form[name=complete]').submit();", array('class' => 'btn btn-primary')); ?>
	</div>

<?php elseif ($this->request->action == 'deleteConfirm') : // 削除確認画面 ?>

	<?php
		echo $this->Form->create($formEntity, ['url' => ['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'deleteComplete'], 'name' => 'complete']);
		echo $this->Form->hidden('id');
		echo $this->Form->end();
	?>

	<div>
		<?php echo $this->Html->link('戻る', ['plugin' => null, 'controller' => $settings['tableName'], 'back' => true], ['class' => 'btn btn-warning']); ?>
		<?php echo $this->Html->link('完了', "javascript:jQuery('form[name=complete]').submit();", array('class' => 'btn btn-primary')); ?>
	</div>

<?php elseif ($this->request->action == 'show') : // 詳細画面 ?>

	<div>
		<?php echo $this->Html->link('戻る', ['plugin' => null, 'controller' => $settings['tableName'], 'back' => true], ['class' => 'btn btn-warning']); ?>
	</div>

<?php endif; // ここまで ?>
