<?php
	use Cake\Utility\Inflector;
?>

<?php $this->Html->scriptStart(['block' => true]); ?>
	<?php $this->Minify->scriptStart(); ?>
		jQuery(function($){
			// buttonによりsubmitの対象を変える
			var previewAction = '<?php echo $this->Url->build(['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'preview']); ?>';
			var confirmAction = '<?php echo $this->Url->build(['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'confirm']); ?>';
			var completeAction = '<?php echo $this->Url->build(['plugin' => null, 'controller' => $settings['tableName'], 'action' => 'complete']); ?>';
			$('#formPreview').click(function(){
				jQuery('form[name=form]').attr('action', previewAction).attr('target', '_blank').submit();
			});
			$('#formConfirm').click(function(){
				jQuery('form[name=form]').attr('action', confirmAction).attr('target', '_self').submit();
			});
			$('#formComplete').click(function(){
				jQuery('form[name=form]').attr('action', completeAction).attr('target', '_self').submit();
			});

			// ENTERキーでsubmit
			$(document).on('keydown', 'input', function(e){
				e = e || window.event;
				if(e.keyCode == 13) {
					<?php if (!empty($privateSettings['useConfirm'])) : ?>
						$('#formConfirm').click();
					<?php else : ?>
						$('#formComplete').click();
					<?php endif; ?>
				}
			});
		});
	<?php $this->Minify->scriptEnd(); ?>
<?php $this->Html->scriptEnd(); ?>

<h1><?php echo $subject; ?>管理</h1>
<h2><?php echo $subject; ?><?php echo (empty($formEntity->id) ? '登録' : '編集'); ?></h2>

<?php echo $this->Form->create($formEntity, ['url' => null, 'type' => 'file', 'name' => 'form', 'target' => '_self', 'novalidate' => true]); ?>
	<table class="table table-bordered form">
		<?php if (in_array('_form', $templateFiles)) : ?>
			<?php echo $this->element('..' . DS . 'Admin' . DS . $settings['tableName'] . DS . '_form'); ?>
		<?php else : ?>
			<?php echo $this->element('MasterCrud._form'); ?>
		<?php endif; ?>
	</table>

	<?php echo $this->Form->hidden('id'); ?>
<?php echo $this->Form->end(); ?>

<div>
	<?php if (!empty($privateSettings['inputBack'])) : // back ?>
		<?php echo $this->Html->link('戻る', ['plugin' => null, 'controller' => $settings['tableName'], 'back' => true], ['class' => 'btn btn-warning']); ?>
	<?php endif; ?>

	<?php if (!empty($privateSettings['inputPreview'])) : // preview ?>
		<?php echo $this->Html->link('プレビュー', 'javascript:void(0);', ['class' => 'btn btn-success', 'id' => 'formPreview']); ?>
	<?php endif; ?>

	<?php if (!empty($privateSettings['useConfirm'])) : // 確認画面利用 ?>
		<?php echo $this->Html->link('確認画面へ', 'javascript:void(0);', ['class' => 'btn btn-primary', 'id' => 'formConfirm']); ?>
	<?php else : ?>
		<?php echo $this->Html->link('完了', 'javascript:void(0);', ['class' => 'btn btn-primary', 'id' => 'formComplete']); ?>
	<?php endif; ?>
</div>