<?php
namespace MasterCrud\Controller\Component;

use Cake\Controller\Component;
use Cbase\Controller\Component\PrivateComponent;
use Cake\Event\Event;
use Cake\Core\Configure;
use Cake\Utility\Text;
use Cake\Utility\Inflector;

/**
 * MasterCrudPrivateコンポネント
 * @author ueno
 *
 * master_crud用
 */
class MasterCrudPrivateComponent extends PrivateComponent {

    /**
     * 独自に用意したテンプレートファイル名を格納する
     */
    protected $_templateFiles = [];

    /**
    * initialize
     *
     * @param Controller $controller
    */
    public function initialize(array $config)
    {
        parent::initialize($config);

        // indexへのリダイレクトURL(例:コントローラ名:Spots =>'/admin/spots/index')
        $this->redirectUrl = $redirectUrl = [
            'plugin'        => null,
            'controller'    => $this->request->params['settings']['tableName'],
            'action'        => 'index',
            'prefix'        => 'admin'
        ];
        $this->controller->set(compact("redirectUrl"));

        // templateFiles
        $targetDir = APP . 'Template' . DS . 'Admin' . DS . $this->request->params['settings']['tableName'];
        if (file_exists($targetDir) && $dir = opendir($targetDir)) {
            while (($file = readdir($dir)) !== false) {
                if ($file != "." && $file != "..") {
                    $this->_templateFiles[] = str_replace('.ctp', '', $file);
                }
            }
            closedir($dir);
        }
        $this->controller->set('templateFiles', $this->_templateFiles);
    }

    /**
     * render
     * @param string $name 'add' or 'confirm'
     *  nullの場合action名で判断
     *      action = add, edit  ====> add
     *      action = confirm, deleteConfirm  ====> confirm
     * @return mixed｜void renderできない場合はfalseが返る
     */
    public function adminRender($name = null)
    {
        if (empty($name)) {
            $action = $this->request->action;
            if(in_array($action, ['add', 'edit', 'copy'])) $name = 'add';
            elseif(in_array($action, ['confirm', 'deleteConfirm', 'show'])) $name = 'confirm';
            elseif(in_array($action, ['index'])) $name = 'index';
            else return false;
        }

        if (in_array($name, $this->_templateFiles)) {
            // 用意されたtemplateを利用
            $this->controller->render(DS . ".." . DS . "Template" . DS . "Admin" . DS . $this->request->params['settings']['tableName'] . DS . $name);
        } else {
            // defaultのテンプレート(plugin内)を利用
            $this->controller->render("MasterCrud./Admin/MasterCrud/{$name}");
        }
    }

}

