<?php
namespace MasterCrud\Controller\Admin;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;

class MasterCrudController extends AppController
{

    /**
     * Adminの各CRUD処理を行うTable
     * 各controllerで上書き可能
     */
    public $mainTable = null;

    /**
     * components
     */
    public $components = ['Paginator', 'Flash', 'MasterCrud.MasterCrudPrivate'];

    /**
     * helpers
     */
    public $helpers = ['Cbase.Minify', 'Cbase.Cform', 'MasterCrud.MasterCrud'];

    /**
     * PrivateComponentの設定
     */
    public $privateSettings = [
        'useConfirm' => false, // 確認,削除確認画面を使うか
        'inputPreview' => false, // 入力画面にプレビューボタンを表示させるか
    ];

    /**
     * Paginator設定
     */
    public $paginate = [
        'limit' => 20,
    ];

    /**
     * routesから渡ってきたsetting
     */
    protected $_settings = [];

    /**
     * 確認画面かどうか
     */
    public $confirmForm = false;

    /*
     * beforeFilter
     */
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        // settings
        $this->_settings = $this->request->params['settings'];

        // mainTable
        $this->mainTable = $this->MasterCrudPrivate->mainTable = $this->_settings['tableName'];

        if (empty($this->{$this->mainTable})) {
            $this->{$this->mainTable} = TableRegistry::get($this->mainTable);
        }

        // paginate
        $this->paginate = $this->_settings['paginate'];
        // useConfirm
        $this->privateSettings['useConfirm'] = $this->_settings['useConfirm'];
        // subject
        $this->set('subject', $this->subject = $this->_settings['subject']);
        // set settings
        $this->set('settings', $this->_settings);

    }

    /**
     * Before render callback.
     */
    public function beforeRender(Event $event)
    {
        parent::beforeFilter($event);

        if (!empty($this->_settings['beforeRender'])) {
            $this->_settings['beforeRender']($this);
        }
    }

    /**
     * 一覧
     */
    public function index()
    {
        // 共通処理
        $this->MasterCrudPrivate->index();
        // ページネーション付きデータ取得し、viewに渡す
        $this->paginate = array_merge($this->paginate, $this->{$this->mainTable}->getOptions($this->request->query, true));
        $this->set('datas', $this->paginate($this->{$this->mainTable}));

        $this->MasterCrudPrivate->adminRender();
    }

    /**
     * 詳細表示
     */
    public function show($id = null) {
        // 共通処理
        $this->MasterCrudPrivate->show($id);
    }

    /**
     * プレビュー
     */
    public function preview($id = null) {
    }

    /**
     * 登録
     */
    public function add()
    {
        // 共通処理
        $this->MasterCrudPrivate->add();
    }

    /**
     * コピー
     */
    public function copy($id = null)
    {
        // 共通処理
        $this->MasterCrudPrivate->copy($id, ['text' => ['title' => 'のコピー']]);
    }

    /**
     * 編集
     */
    public function edit($id = null)
    {
        // 共通処理
        $this->MasterCrudPrivate->edit($id);
    }

    /**
     * 確認
     */
    public function confirm()
    {
        // 共通処理
        $this->MasterCrudPrivate->confirm();
    }

    /**
     * 完了
     */
    public function complete()
    {
        // 共通処理
        $this->MasterCrudPrivate->complete();
    }

     /**
     * 削除確認
     */
    public function deleteConfirm($id = null)
    {
        // 共通処理
        $this->MasterCrudPrivate->deleteConfirm($id);
    }

    /**
     * 削除完了
     */
    public function deleteComplete($id = null)
    {
        // 共通処理
        $this->MasterCrudPrivate->deleteComplete($id);
    }

}
