<?php
use Cake\Routing\Router;
use Cake\Core\Configure;
use Cake\Utility\Inflector;

Router::plugin('MasterCrud', function ($routes) {
    $routes->fallbacks('InflectedRoute');
});
// admin routing
Router::prefix('admin', function ($routes) {
    $routes->plugin('MasterCrud', function ($subRoutes) {
        $subRoutes->fallbacks('InflectedRoute');
    });
});

// admin routing固定
Router::prefix('admin', function ($routes) {
    // 設定読み込み
    Configure::load('master_crud');
    $settings = Configure::read('MasterCrud');

    foreach ($settings as $tableName => $setting) {
        $underscore = Inflector::underscore($tableName);
        $setting['tableName'] = $tableName;
        $routes->connect("/{$underscore}/:action/*", ['controller' => 'MasterCrud', 'plugin' => 'MasterCrud', 'settings' => $setting]);
        $routes->connect("/{$underscore}", ['controller' => 'MasterCrud', 'action' => 'index', 'plugin' => 'MasterCrud', 'settings' => $setting]);
    }
    $routes->fallbacks('InflectedRoute');
});