<?php

namespace Uehi\Larapack;


use Illuminate\Support\Facades\Response;

class Csv
{

    /**
     * CSV形式にする為の親関数
     * @param $var
     * @return array
     */
    private function changeCsv($var)
    {
        return $this->csvList($var);
    }

    /**
     * コントローラで使われているテーブルデータをCSV化して返す
     * @param $var
     * @return array
     */
    private function csvList($var)
    {
        $var = $this->addEnclosures($var);

        $list = array();
        foreach ($var as $value) {
            $list[] = implode(",", $value) . "\r\n";
        }

        return $list;
    }

    /**
     * 「"」を付加する為の再帰関数
     * @param $var
     * @return unknown_type|array
     */
    private function addEnclosures($var)
    {
        if (is_array($var)) {
            foreach ($var as $key => $value) {
                $var[$key] = $this->addEnclosures($value);
            }
            return $var;
        } else {
            return $this->enclosures($var);
        }
    }

    /**
     * CSV形式「"」を付加して返す
     * @param $var
     * @return string
     */
    private function enclosures($var)
    {
        return "\"" . $var . "\"";
    }

    /**
     * ファイルに書き出す
     */
    public function writeFile($head, $body, $filepath)
    {

        // タイトル行を取得、CSV用に加工、セット
        $head = implode(',', $this->addEnclosures($head));

        // データを取得、CSV用に加工、セット
        $body = $this->changeCsv($body);

        // 書き込むデータ
        $data = '';
        if (!empty($head))			$data .= mb_convert_encoding($head, 'SJIS-win', 'UTF-8') . "\r\n";
        foreach ($body as $csv)		$data .= mb_convert_encoding($csv,  'SJIS-win', 'UTF-8');

        // ファイルを追記モードで開く
        $fp = fopen($filepath, 'ab');
        // ファイルを排他ロックする
        flock($fp, LOCK_EX);
        // ファイルの中身を空にする
        ftruncate($fp, 0);
        // データをファイルに書き込む
        fwrite($fp, $data);
        // ファイルを閉じる
        fclose($fp);
    }

    /**
     * ダウンロード処理
     */
    public function output($head, $body, $name)
    {
        // タイトル行を取得、CSV用に加工、セット
        $head = implode(',', $this->addEnclosures($head));

        // データを取得、CSV用に加工、セット
        $body = $this->changeCsv($body);

        // 書き込むデータ
        $data = '';
        if (!empty($head))			$data .= mb_convert_encoding($head, 'SJIS-win', 'UTF-8') . "\r\n";
        foreach ($body as $csv)		$data .= mb_convert_encoding($csv,  'SJIS-win', 'UTF-8');

        // header
        $name = "{$name}.csv";
        $headers = [
            "Content-type" => 'text/csv',
            "Content-Disposition" => 'attachment; filename*=UTF-8\'\'' . rawurlencode($name),
        ];
        return Response::make($data, 200, $headers);
    }

}