<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Foundation\Console\ModelMakeCommand as ModelMakeCommandOriginal;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ModelMakeCommand extends ModelMakeCommandOriginal
{

    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'larapackmake:model';

    /**
     * Get the desired class name from the input.
     *
     * @return string
     */
    protected function getNameInput()
    {
        return 'Models/' . trim($this->argument('name'));
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return __DIR__.'/stubs/model.stub';
    }

    /**
     * Replace the class name for the given stub.
     *
     * @param  string  $stub
     * @param  string  $name
     * @return string
     */
    protected function replaceClass($stub, $name)
    {
        $stub = parent::replaceClass($stub, $name);

        $class = str_replace($this->getNamespace($name).'\\', '', $name);
        $class = str_replace('Request', '', $class);
        $table = Str::plural(Str::snake($class));

        // 現在tableがある場合カラム名を入れる
        $fillableColumnsStr = '';
        $keywordColumnsStr = '';
        $useSoftDeletesStr = '';
        $traitSoftDeletesStr = '';
        if (DB::select("show tables like '{$table}';")) {
            // DummyColumns
            $ignores = [
                'id',
                'public',
                'created_at',
                'updated_at',
                'deleted_at',
                'created_id',
                'updated_id',
                'deleted_id',
            ];
            $dbColumns = DB::select("show columns from {$table};");
            $softDeletes = false;
            $fillableColumns = [];
            $keywordColumns = [];
            foreach ($dbColumns as $column) {
                // softDeletesを読み込むかフラグ
                if ($column->Field === 'deleted_at') {
                    $softDeletes = true;
                }
                if (!in_array($column->Field, $ignores)) {
                    // fillable
                    $fillableColumns[] = "'{$column->Field}'";
                    // keywordはtext関係のみ含める
                    $type = $column->Type;
                    if (preg_match('/^(varchar|char|text)/', $type)) {
                        $keywordColumns[] = "'{$column->Field}'";
                    }
                }
            }
            if (!empty($fillableColumns)) {
                $fillableColumnsStr = implode(', ', $fillableColumns);
            }
            if (!empty($keywordColumns)) {
                $keywordColumnsStr = implode(', ', $keywordColumns);
            }

            // SoftDeletes
            if ($softDeletes) {
                $useSoftDeletesStr = 'use Illuminate\Database\Eloquent\SoftDeletes;';
                $traitSoftDeletesStr = ', SoftDeletes';
            }
        }
        $stub = str_replace('DummyFillableColumns', $fillableColumnsStr, $stub);
        $stub = str_replace('DummyKeywordColumns', $keywordColumnsStr, $stub);
        $stub = str_replace('UseSoftDeletes', $useSoftDeletesStr, $stub);
        $stub = str_replace('TraitSoftDeletes', $traitSoftDeletesStr, $stub);

        return $stub;
    }

}
