# README #

Laravelの管理画面等共通機能をまとめたPackageです。
LaravelのPackageなのでLarapackとしています。

## ■ 導入条件

- Laravel 5.4系で動作確認済

## ■ Install

### composer追加

Laravelインストール直後にインストールして利用する想定です。
通常の通りLaravelをインストールし、config/app.php, database.php, .env等設定後、
composer.jsonに以下を追加します。

```
"require": {
    ...
    "uehi/larapack": "dev-master"
},
```

また、Privateリポジトリなので以下repositoriesにも追加します。

※そのため、composer updateはこのリポジトリが扱える権限配下で実行する必要があります。

```
"repositories": [
    {
        "type": "git",
        "url": "git@bitbucket.org:w012/larapack.git"
    }
],
```

```
上記レポジトリで動かなかったため下記を記入：callnaviプロジェクトを参照
    "repositories": [
        {
            "packagist": false
        },
        {
            "type": "composer",
            "url": "https://monitor.012grp.co.jp/satis"
        }
    ],
```

composer.json追加後、update実行

```
$ composer update
```

### ServiceProvider登録

config/app.php内に以下追加。


'providers'に

```
'providers' => [
    ...
    
    
    /**
     * add
     */
    Collective\Html\HtmlServiceProvider::class,
    Uehi\Larapack\Providers\LarapackServiceProvider::class,
],
```

'aliases'に

```
'aliases' => [
    ...
    
    
    /**
     * add
     */
    'Form' => Collective\Html\FormFacade::class,
    'Html' => Collective\Html\HtmlFacade::class,
],
```

を追加。


### コマンド実行

一旦cache破棄

```
$ php artisan config:cache
```

インストールコマンド実行

```
$ php artisan larapack:install
```

おわったあともやる

```
php artisan config:cache
```

/admin/にアクセスしてみる。

- basic認証:  admin/admin
- ログイン: admin/admin

でログインできたら成功。
デフォルトで管理ユーザ管理機能がある。


## ■ 何らかの1機能を作ってみる

記事管理(articles)でも作ってみる。

### migration作る

"Article"はモデル名
```
$ php artisan larapackmake:migration Article
```

migrateファイルができるので適当にいじって実行。
実行はいつもどおり

```
$ php artisan migrate
```

### CRUD作る

```
$ php artisan larapackmake:crud Article
```

あとは/admin/articlesにアクセスできたらOK。

### メニューに追加しとこう

projdir/resources/views/vendor/larapack/partials/admin/_menu.blade.php

にある。

### あとはCRUDのカスタマイズ

以下にファイルが生成されている。

- view関係
    - projdir/resources/views/admin/articles/
- controller
    - projdir/app/Http/Controllers/Admin/ArticlesController.php
- model
    - projdir/app/Models/Article.php
- request
    - projdir/app/Http/Requests/ArticleRequest.php

あたりのファイルを変更して好みの形にしていく。


## ■ このパッケージを使うにあたっての規約

なんでも自由にするとパッケージングしにくいので以下の規約を前提としている

※namespaceもディレクトリと同じ構造となる

### テーブル名
snake case 複数形 (admin_users)

### モデル名
upper camel 単数形 (AdminUser)

app/Models/ に配置

### controller名
"upper camel複数形" + Controller (AdminUsersController)
    
app/Http/Controllers/Admin/ に配置

### request名

"モデル名" + Request (AdminUserRequest)

 app/Http/Requests/ に配置

### view

resources/views/admin/{snake case 複数形} に配置

ルールとして

- 一覧(index.blade.php)内に
    - _search.blade.php (検索BOX部分)
    - _list.blade.php (一覧部分)
    
    が読み込まれる
    
- 新規登録と編集と詳細(create.blade.phpひとつを共用)内に
    - _form.blade.php (form部分)
    
    が読み込まれる

これらのファイルが resources/views/admin/{snake case 複数形}
に存在する場合それを読み込み、なければpackage内の同名ファイルを読み込む。

つまりカスタマイズする場合は外出しすればよい。


### 管理ユーザ

admin_usersテーブル固定で運用


## ■ DEMO

以下のリポジトリをcloneして閲覧ください。

[https://bitbucket.org/w012/larapack-example](https://bitbucket.org/w012/larapack-example)


## ■ Version Tag

現在ベータ版のため、dev-masterでの運用となっているが、整備後バージョン番号つける予定。