<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Routing\Console\ControllerMakeCommand as ControllerMakeCommandOriginal;
use Symfony\Component\Console\Input\InputOption;
use Illuminate\Support\Str;

class ControllerMakeCommand extends ControllerMakeCommandOriginal
{

    /**
     * The console command signature.
     *   single: 設定画面などフォーム1画面の機能を出したい場合
     * @var string
     */
//    protected $signature = 'larapackmake:controller {name : The name of model class.} {--single : in case form page only.}';
    protected $name = 'larapackmake:controller';

    /**
     * Get the desired class name from the input.
     *
     * @return string
     */
    protected function getNameInput()
    {
        return 'Admin/' . Str::plural(trim($this->argument('name'))) . 'Controller';
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        $isSingle = $this->option('single');
        $name = $isSingle ? 'controller_single' : 'controller';
        return __DIR__.'/stubs/'.$name.'.stub';
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        $options = parent::getOptions();
        $options[] = ['single', 's', InputOption::VALUE_OPTIONAL, 'in case form page only.'];
        return $options;
    }

}
