@php
    /**
     * model
     * request
     * column
     * fileClass
     * divClass
     * errorOptions
     */
    $uploadUrl = url('/uploader/upload');
    if (preg_match('/^(.+)\[([0-9]+)\]\[(.+)\]$/', $column, $m)) {
        $deleteName = "{$m[1]}[{$m[2]}][{$m[3]}" . app('config')->get('const.uploads.delete_suffix') . "]";
    } else {
        $deleteName = $column . app('config')->get('const.uploads.delete_suffix');
    }
@endphp

<script type="text/javascript">
    jQuery(function($) {
        var uploadUrl = '{{ $uploadUrl }}';
        var column = '{{ $column }}';
        var model = '{{ $model }}';
        var request = '{{ $request }}';
        var fileSel = '.{{ $fileClass }}';
        var divSel = '.{{ $divClass }}';
        var loader = '<img src="{{ asset('/larapack/img/loader_small.gif') }}">';
        var errorOptions = {!! json_encode($errorOptions) !!};

        // unique id付加しているので被らない想定
        var container = $(divSel);
        var fileObj = $(fileSel);

        $(document).on('change', fileSel, function() {
            // ファイルがない場合なにもしない
            if (this.files.length <= 0) {
                return;
            }
            var that = this;

            container.html(loader);
            // submitされないように全てのボタンはdisable
            $('.btn').attr('disabled', true);

            // ajaxでファイルのみPOST
            var fd = new FormData();
            var name = column;
            var files = that.files;
            $.each(files, function(i, file) {
                fd.append(name, file);
            });
            // その他必要なもの
            fd.append('model', model);
            fd.append('request', request);
            fd.append('column', column);
            fd.append('error_options', JSON.stringify(errorOptions));
            // csrf
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            $.ajax({
                url: uploadUrl,
                type: 'POST',
                data: fd,
                contentType: false,
                processData: false,
                cache : false,
                success: function(html) {
                    container.html(html);
                    // input type fileを空にするため置き換え
                    fileObj.replaceWith(fileObj = fileObj.clone(true));
                    fileObj.val('');
                    $('.btn').attr('disabled', false);
                },
                error: function(obj) {
                    if (obj.responseJSON[column]) {
                        obj.responseJSON[column].forEach (function(val, i) {
                            showError(val);
                        });
                        $('.btn').attr('disabled', false);
                    }

                    // reset
                    fileObj.replaceWith(fileObj = fileObj.clone(true));
                    fileObj.val('');
                }
            });
        });

        // error templateを使いエラーメッセージを生成
        function showError(msg) {
            var error = errorOptions.template.replace('[[error]]', msg);
            if (errorOptions.selector) {
                // 指定dom
                $(errorOptions.selector).html(error);
            } else {
                // defaultはcontainer置き換え
                container.html(error);
            }
        }

        // 削除処理
        $(document).on('click', '.inputFileDelBtn', function(){
            container.html('{{ Form::hidden($deleteName, 1) }}');
            fileObj.replaceWith(fileObj = fileObj.clone(true));
            fileObj.val('');
            return false;
        });
    });
</script>