<?php
/**
 * routes(主に管理画面)
 */

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

// admin
Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'web'], function() {
    // login, logout
    Route::get('login', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@showLoginForm')->name('login');
    Route::post('login', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@login')->name('login');
    Route::get('logout', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@logout')->name('logout');

    // その他(認証必要)
    Route::group(['middleware' => 'auth.admin'], function() {
        // admin_users
        Route::resource('admin_users', 'App\Http\Controllers\Admin\AdminUsersController');
        // admin controllers
        $wizcloud = ['wizcloud'];
        $projects = get_project_names();
        $projects = array_merge($projects, $wizcloud);

        $registerfunc = function ($adminControllerPath, $namespace) {
            if (file_exists($adminControllerPath)) {
                $controllers = File::glob("{$adminControllerPath}/*Controller.php");
                if (!empty($controllers)) {
                    foreach ($controllers as $controller) {
                        $name = basename($controller, 'Controller.php');
                        $controller = basename($controller, '.php');
                        if ($name !== 'Home') { // HomeControllerは除外
                            $snake = Str::snake($name);
                            $snakeSingle = Str::singular($snake);

                            // Route::resource分を直で書く(id where制約を書きたいので)
                            Route::get("/{$snake}/", "{$controller}@index")->name("{$snake}.index");
                            Route::post("/{$snake}/", "{$controller}@store")->name("{$snake}.store");
                            Route::get("/{$snake}/create", "{$controller}@create")->name("{$snake}.create");
                            Route::get("/{$snake}/{{$snakeSingle}}", "{$controller}@show")->name("{$snake}.show")->where($snakeSingle, '[0-9]+');
                            Route::match(['PUT', 'PATCH'], "/{$snake}/{{$snakeSingle}}", "{$controller}@update")->name("{$snake}.update")->where($snakeSingle, '[0-9]+');
                            Route::delete("/{$snake}/{{$snakeSingle}}", "{$controller}@destroy")->name("{$snake}.destroy")->where($snakeSingle, '[0-9]+');
                            Route::get("/{$snake}/{{$snakeSingle}}/edit", "{$controller}@edit")->name("{$snake}.edit")->where($snakeSingle, '[0-9]+');

                            // preview method用意している場合preview routingする
                            if (method_exists(app("{$namespace}{$controller}"), 'preview')) {
                                Route::post("/{$snake}/preview", "{$controller}@preview")->name("{$snake}.input_preview_create");
                                Route::post("/{$snake}/{" . Str::singular($snake) . "}/preview", "{$controller}@preview")->name("{$snake}.input_preview_edit");
                                Route::get("/{$snake}/{" . Str::singular($snake) . "}/preview", "{$controller}@preview", 'id')->name("{$snake}.preview");
                            }
                        } else {
                            // homeは最後に登録する
                            $isHomeExists = true;
                        }
                    }
                }
            }
        };

        foreach ($projects as $project) {
            /**
             * wizcloudとその他サブディレクトリのプロジェクトでルーティング切り替え
             */
            $prefixes = [];
            $names = [];
            if ($project === 'wizcloud') {
                $adminControllerPath = app_path('Http/Controllers/Admin');
                $namespace = 'App\Http\Controllers\Admin\\';
            } else {
                $projectToDirName = Str::ucfirst(Str::camel($project));
                $adminControllerPath = app_path("Http/Controllers/Projects/{$projectToDirName}/Admin");
                $namespace = str_replace(base_path(), '', $adminControllerPath);
                $namespace = str_replace('/', '\\', $namespace);
                $namespace = str_replace('.php', '', $namespace);
                $namespace = ltrim($namespace, '\\');
                $namespace = Str::ucfirst($namespace) . "\\";
                $prefixes[] = $project;
                $names[] = $project;
            }
            Route::group(['prefix' => implode('/', $prefixes), 'namespace' => $namespace, 'name' => implode('.', $names) . '.'],
                function () use ($registerfunc, $adminControllerPath, $namespace) {
                    $registerfunc($adminControllerPath, $namespace);
                });
        }

        // larapack
        Route::patch('/larapack/changePublic', 'Uehi\Larapack\Controllers\Admin\LarapackController@changePublic')->name('larapack.change_public');
        Route::patch('/larapack/changeSequence', 'Uehi\Larapack\Controllers\Admin\LarapackController@changeSequence')->name('larapack.change_sequence');

        // home
        if (!empty($isHomeExists)) {
            Route::get('/', 'App\Http\Controllers\Admin\HomeController@index')->name('home');
        } else {
            Route::get('/', 'Uehi\Larapack\Controllers\Admin\HomeController@index')->name('home');
        }
    });
});

// admin以外
Route::group(['middleware' => 'web'], function () {
    // uploader
    Route::post('/uploader/upload', 'Uehi\Larapack\Controllers\UploaderController@upload')->name('uploader.upload');
    Route::get('/uploader/readTmp/{filename}', 'Uehi\Larapack\Controllers\UploaderController@readTmp')->name('uploader.read_tmp')->where('filename', '(.+)');
    Route::get('/uploader/read/{model}/{id}/{column}', 'Uehi\Larapack\Controllers\UploaderController@read')->name('uploader.read');
});

// サブディレクトリ
foreach (File::glob(base_path('routes/projects/*/*.php')) as $path) {
    $basename = basename($path);
    $project = basename(dirname($path));
    $projectNamespace = Str::ucfirst(Str::camel(basename(dirname($path))));
    switch ($basename) {
        case 'admin.php':
            Route::middleware(['web', 'auth.admin'])
                ->name("admin.")
                ->prefix("admin")->group(function () use ($project, $projectNamespace, $path) {
                    Route::name("{$project}.")
                        ->prefix($project)
                        ->namespace("Http\\Controllers\\Projects\\{$projectNamespace}")
                        ->group($path);
                });
            break;
        case 'web.php':
            Route::middleware(['web'])
                ->name("{$project}.")
                ->prefix("{$project}")
                ->namespace("{Http\\Controllers\\Projects\\{$projectNamespace}")
                ->group($path);
            break;
        default:
            Route::name("{$project}.")
                ->prefix("{$project}")
                ->namespace("{Http\\Controllers\\Projects\\{$projectNamespace}")
                ->group($path);
    }
}
