<!DOCTYPE html>
<html lang="ja">
<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="imagetoolbar" content="no" />
    <meta name="ROBOTS" content="noindex, nofollow" />
    <title>管理画面｜{{ config('app.name') }}</title>
    @include('larapack::partials.admin._meta')

    {{-- this app css --}}
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.2.1/css/bootstrap.min.css" integrity="sha384-GJzZqFGwb1QTTN6wy59ffF1BuGJpLSa9DkKMp0DgiMDm4iYMj70gZWKYbI706tWS" crossorigin="anonymous">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/non-responsive.css') }}">
    <link rel="stylesheet" href="//fonts.googleapis.com/earlyaccess/roundedmplus1c.css">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/theme.min.css') }}">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/admin.css') }}">

    @section('css')
    @show
    @section('cssBlock')
    @show

    {{-- jQuery --}}
    <script
        src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
        crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.6/umd/popper.min.js" integrity="sha384-wHAiFfRlMFy6i5SRaxvfOCifBUQy1xHdJ/yoi7FRNXMRBu5WHdZYu1hA6ZOblgut" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.2.1/js/bootstrap.min.js" integrity="sha384-B0UglyR+jN6CkvvICOB2joaf5I4l3gm9GU6Hc1og6Ls7i6U/mkkaduKaBhlAXv9k" crossorigin="anonymous"></script>
    <script src='//ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js'></script>

    {{-- 共通scripts --}}
    @include('larapack::partials._common_js')

    @section('js')
    @show
    @section('jsBlock')
    @show

</head>

<body>

@if (!empty($auth)) {{-- ログイン済み --}}

    <nav class="navbar navbar-inverse navbar-fixed-top navbar-expand-lg" role="navigation">
        <div class="navbar-header">
            <a href="{{ url('/admin/') }}" class="navbar-brand">{{ config('app.name') }}</a>
        </div>

        <ul class="nav navbar-nav navbar-left">
            <li><a href="{{ url('/') }}" target="_blank">サイトを表示</a></li>
        </ul>

        <div class="collapse navbar-collapse" id="navbarNavDropdown">
            <ul class="nav navbar-nav navbar-right ml-auto">
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="glyphicon glyphicon-user icon-white"></i> {{ $auth['title'] }} 様
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="{{ url('/admin/logout') }}"><i class="glyphicon glyphicon-off icon-black"></i> ログアウト</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="sidebar" id="sidebar">
            @include('larapack::partials.admin._menu')
        </div>

        <div class="main">
            {!! Larapack::flash('warning') !!}
            @yield('content')
        </div>
    </div>

@else {{-- ログイン画面 --}}

    <div class="main-login">
        <div class="panel panel-default center-block">
            <div class="panel-heading">
                <h3 class="panel-title text-center">
                    {{ config('app.name') }}
                </h3>
            </div>
            <div class="panel-body loginBox">
                {!! Larapack::flash() !!}
                @yield('content')
            </div>
        </div>
    </div>

@endif

</body>
</html>
