<?php

namespace Uehi\Larapack\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Uehi\Larapack\Facades\Larapack;

class LarapackController extends Controller
{

    /**
     * Ajax用公開非公開変更
     * PATCH [flag] => 1, [id] => 1, [model] => App\Models\Examples, [field] => public
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function changePublic()
    {
        $model = app('request')['model'];
        $id = app('request')['id'];
        $field = app('request')['field'];
        $flag = app('request')['flag'];

        $record = $model::findOrFail($id);
        $record->{$field} = $flag;
        return $record->save() ? '' : 'error';
    }

    /**
     * 並び順の更新
     * @return string
     */
    public function changeSequence()
    {
        $model = app('request')['model'];
        $id = app('request')['id'];
        $field = app('request')['field'];
        $value = app('request')['value'];

        $record = $model::findOrFail($id);
        $record->{$field} = $value;
        $msgId = $record->save() ? 'larapack::admin.sequence_ok' : 'larapack::admin.sequence_ng';
        $msg = trans($msgId);
        Larapack::setFlash($msg);
        if (!empty(app('request')['redirect'])) {
            return redirect(app('request')['redirect']);
        } else {
            return redirect()->back();
        }
    }
}
