<?php

namespace Uehi\Larapack\Extensions\Database\Migrations;

use Illuminate\Database\Migrations\MigrationCreator as MigrationCreatorOriginal;

class MigrationCreator extends MigrationCreatorOriginal
{

    /**
     * Get the migration stub file.
     * custom stubを読み込む
     * @param  string  $table
     * @param  bool    $create
     * @return string
     */
    protected function getStub($table, $create)
    {
        return $this->files->get($this->customStubPath() . '/migration_create.stub');
    }

    /**
     * customのstubパス
     */
    private function customStubPath()
    {
        return dirname(dirname(dirname(dirname(__FILE__)))).'/Commands/stubs';
    }

    /**
     * Populate the place-holders in the migration stub.
     *
     * @param  string  $name
     * @param  string  $stub
     * @param  string  $table
     * @return string
     */
    protected function populateStub($name, $stub, $table)
    {
        $stub = str_replace('DummyClass', $this->getClassName($name), $stub);

        // Here we will replace the table place-holders with the table specified by
        // the developer, which is useful for quickly creating a tables creation
        // or update migration from the console instead of typing it manually.
        if (! is_null($table)) {
            $stub = str_replace('DummyTable', $table, $stub);
        }

        return $stub;
    }

}