var geocoder = new google.maps.Geocoder();
var Gmap = function(anElement, args){
	this.element = anElement;
	this.config = exMerge({
		width           : 500,
		height          : 400,
		centerLatLng    : [33.590355, 130.401716],	// fukuoka city
		zoom            : 10,
		mapTypeId		: google.maps.MapTypeId.ROADMAP,
				scaleControl	: true
	}, args);
	this.config['center'] = new google.maps.LatLng(this.config['centerLatLng'][0], this.config['centerLatLng'][1]);
	this.map = new Object();

};

// 表示
Gmap.prototype.show = function(){
	this.map = new google.maps.Map(this.element, this.config);
	this.map.currentInfoWindow = null;
};

// マーカー作成
Gmap.prototype.setMarker = function(position, html, image, options){
	options = $.extend({
		draggable: false,
		anchor: null,
	}, options);

	var icon;
	var center;

	if(image){
		// 文字列の場合、画像パスとみなす
		if(typeof image == 'string') icon = image;
		else if(typeof image == 'object'){
			if (!options.anchor) {
				icon = new google.maps.MarkerImage(
					image.src,											// url
					new google.maps.Size(image.width, image.height),	// size
					new google.maps.Point(0,0)							// origin
				//	new google.maps.Point(16,16)						// anchor
				);
			} else {
				var anchor = null;
				if (options.anchor == 'center') {
					anchor = new google.maps.Point(image.width / 2, image.height / 2);
				}
				icon = new google.maps.MarkerImage(
					image.src,											// url
					new google.maps.Size(image.width, image.height),	// size
					new google.maps.Point(0,0),							// origin
					anchor												// anchor
				);
			}
		}else{return false;}
	}

	if(position instanceof Array) center = new google.maps.LatLng(position[0], position[1]);
	else if(typeof position == 'object') center = position;

	var marker = new google.maps.Marker({
		position : center,
		map      : this.map,
		icon     : icon,
		draggable: (options.draggable ? true : false)
	//	title    : point['title'] ,
	});

	if(html){
		var infowindow = new google.maps.InfoWindow({
			content: html
		});

		// ふきだし
		google.maps.event.addListener(marker, 'click', function() {
			//先に開いた情報ウィンドウがあれば、closeする
			if (this.map.currentInfoWindow) {
				this.map.currentInfoWindow.close();
			}

			//情報ウィンドウを開く
			infowindow.open(this.map, marker);
			this.map.currentInfoWindow = infowindow;
		});

	}

	return marker;
};

// マーカー削除
Gmap.prototype.removeOverlay = function(marker){
	if(marker) marker.setMap(null);
};

// ルート案内の線を引く
Gmap.prototype.setRoute = function(coords, mode){
	// 座標が2つ未満の場合はなにもしない
	if(coords.length < 2){
		return;
	}


	if(!mode){
		mode = google.maps.DirectionsTravelMode.DRIVING;
	}
	var directionsService = new google.maps.DirectionsService();
	var directionsDisplay = new google.maps.DirectionsRenderer({
		map: this.map,
		suppressMarkers: true
	});

	// 始点、終点、経由地を出す
	var start, end;
	var waypoints = [];
	for (i = 0; i < coords.length; i++) {
		if(i == 0) start = new google.maps.LatLng(coords[i][0], coords[i][1]);
		else if(i == coords.length - 1) end = new google.maps.LatLng(coords[i][0], coords[i][1]);
		else{
			waypoints.push({location: new google.maps.LatLng(coords[i][0], coords[i][1])});
		}
	}

	directionsService.route({
		origin : start,
		destination: end,
		waypoints: waypoints,
		travelMode: mode
	},function(response, status){
		if (status == google.maps.DirectionsStatus.OK) {
			directionsDisplay.setDirections(response);
		}else{
			alert('ルート検索に失敗しました');
		}
	});

};

function exMerge(o, p){
	for (var z in p){
		if (p.hasOwnProperty(z)){
			if (typeof p[z] == 'object' && typeof o[z] == 'object') {
				o[z] = exMerge(o[z], p[z]);
			}else {
				o[z] = p[z];
			}
		}
	}
	return o;
}
