<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Console\Command;

class UninstallCommand extends Command
{
    /**
     * コマンド名
     * @var string
     */
    protected $name = 'larapack:uninstall';

    /**
     * 説明
     * @var string
     */
    protected $description = 'Uninstall Larapack';

    /**
     * Execute
     * @return void
     */
    public function handle()
    {
        if (!$this->confirm('Uninstall?')) {
            return;
        }

        $this->removeFiles();

        $this->line('<info>Uninstalled.</info>');
        $this->line('<info>But the following was nothing to do.</info>');
        $this->line('<info>* DB table</info>');
        $this->line('<info>* AdminUser Model</info>');
        $this->line('<info>* AdminUser Controller</info>');
        $this->line('<info>* AdminUser Request</info>');
        $this->line('<info>Please delete it yourself.</info>');
    }


    /**
     * 外出ししたファイルを削除
     * @return void
     */
    public function removeFiles()
    {
        $this->laravel['files']->deleteDirectory(resource_path('views/vendor/larapack'));
        $this->laravel['files']->deleteDirectory(public_path('larapack'));
        $this->laravel['files']->delete(config_path('const.php'));
    }

}
