@php
    $uploadUrl = url('/uploader/upload');
    if (preg_match('/^(.+)\[([0-9]+)\]\[(.+)\]$/', $column, $m)) {
        $hiddenName = "{$m[1]}[{$m[2]}][{$m[3]}" . app('config')->get('const.uploads.input_suffix') . "]";
    } else {
        $hiddenName = $column . app('config')->get('const.uploads.input_suffix');
    }
@endphp

{{-- エラーを任意の場所に出すor消す --}}
@if (!empty($errorOptions['selector']))
    <script type="text/javascript">
        jQuery(function($){
            var errorOptions = {!! json_encode($errorOptions) !!};

            @if (!empty($errors) && $errors->first($column))
                {{-- errorあり --}}
                var msg = '{{ $errors->first($column) }}';
                var error = errorOptions.template.replace('[[error]]', msg);
                $(errorOptions.selector).html(error);
            @else
                {{-- errorなし --}}
                $(errorOptions.selector).html('');
            @endif
        });
    </script>
@endif

@if (!empty($filename) && empty($isDeleted))
    {{ Html::image($src, '', $imageOptions) }}
    <div class="inputFileDelBtnContainer">
        <a href="javascript:void(0);" class="btn btn-default inputFileDelBtn" style="margin: 10px 0;">
            この画像を削除
        </a>
    </div>
    {{ Form::hidden($hiddenName, $filename) }}
@endif

{{-- error出力場所を明示的に指定している場合出力しない --}}
@if (empty($errorOptions['selector']))
    {{ Larapack::form()->error($column) }}
@endif