<tr>
    <th>{{ Larapack::util()->sortLink('title', '表示名') }}</th>
    <th>{{ Larapack::util()->sortLink('username', 'ログインID') }}</th>
    <th class="w150">{{ Larapack::util()->sortLink('last_login', '最終ログイン') }}</th>
    <th class="w175">{{ Larapack::util()->sortLink('updated_at', '最終更新日/最終更新者') }}</th>
    <th class="w100">{{ Larapack::util()->sortLink('public', '有効/無効') }}</th>
    <th class="w200">操作</th>
</tr>

@if ($records->total() === 0) {{-- データなし --}}

    <tr>
        <td id="noData">条件に合うデータがありません</td>
    </tr>

@endif

@foreach($records as $record)

    <tr>
        <td>
            <a href="{{ admin_url("/{$controllerNameSnake}/{$record->id}/edit") }}">{{ $record->title }}</a>
            @if ($record->id == $auth['id'])
                <span class="label label-danger">あなた</span>
            @endif
        </td>

        <td>
            {{ $record->username }}
        </td>

        <td align="center">
            {{ $record->last_login }}
        </td>

        <td align="center">
            {{ $record->updated_at }}
            <br>
            {{ Larapack::util()->inputUser($record) }}
        </td>

        <td align="center">
            @if ($record->id == $auth['id'])
                {{ config("values.enable.{$record->public}") }}
            @else
                {{ Larapack::util()->selectPublic($record, ['list' => config('values.enable')]) }}
            @endif
        </td>

        <td align="center">
            @if ($record->id == $auth['id'])
                {{ Larapack::util()->operationPanel($record, ['show', 'edit']) }}
            @else
                {{ Larapack::util()->operationPanel($record, ['show', 'edit', 'delete']) }}
            @endif
        </td>
    </tr>

@endforeach