<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Contracts\Filesystem\Filesystem;
use Illuminate\Database\Console\Migrations\BaseCommand;
use Illuminate\Support\Composer;
use Uehi\Larapack\Extensions\Database\Migrations\MigrationCreator;
use Illuminate\Support\Str;

class MigrateMakeCommand extends BaseCommand
{

    /**
     * The console command signature.
     *
     * @var string
     */
    protected $signature = 'larapackmake:migration {name : The name of model class.}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new migration file for Larapack';

    /**
     * The migration creator instance.
     *
     * @var \Illuminate\Database\Migrations\MigrationCreator
     */
    protected $creator;

    public function __construct() {
        parent::__construct();

        $this->creator = new MigrationCreator(app('files'));
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        // It's possible for the developer to specify the tables to modify in this
        // schema operation. The developer may also specify if this table needs
        // to be freshly created so we can create the appropriate migrations.
        $name = trim($this->input->getArgument('name'));
        $this->writeMigration($name);
    }

    /**
     * Write the migration file to disk.
     *
     * @param  string  $name
     * @return string
     */
    protected function writeMigration($name)
    {
        // $name(モデル名)からmigration名を決める
        $table = Str::plural(Str::snake($name));
        $filename = "create_{$table}_table";

        $file = pathinfo($this->creator->create(
            $filename, $this->getMigrationPath(), $table, false
        ), PATHINFO_FILENAME);

        $this->line("<info>Created Migration:</info> {$file}");
    }

}
