<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;

class DockerInstallCommand extends Command
{
    /**
     * コマンド名
     * @var string
     */
    protected $signature = 'larapack:dockerinstall {--php=7.2 : php version ex)7.2}';

    /**
     * 説明
     * @var string
     */
    protected $description = 'Install docker compose file';

    /**
     * Execute
     * @return void
     */
    public function handle()
    {
        $name = basename(base_path());
        $php_version = $this->option('php');

        if (file_exists(base_path("docker-compose.yml"))) {
            $this->line("<info>docker-compose.yml has already exists</info>");
        }
        else {
            $sorce_path =  realpath(__DIR__ . "/../../resources/docker/docker-compose.yml");
            exec("cp " . $sorce_path . " " . base_path());

            $compose_text = file_get_contents(base_path("docker-compose.yml"));
            $compose_text = str_replace("REPLACE_PROJECT_NAME", $name, $compose_text);
            file_put_contents(base_path("docker-compose.yml"), $compose_text);

            $this->line("<info>ddocker-compose.yml copied!</info>");
        }

        if (file_exists(base_path("docker"))) {
            $this->line("<info>docker directory has already exists</info>");
        }
        else {
            $sorce_path =  realpath(__DIR__ . "/../../resources/docker/docker");
            exec("cp -R " . $sorce_path . " " . base_path());

            if(empty($php_version)) { 
                $php_version = "7.2";
            }
            $php_text = file_get_contents(base_path("docker/php/Dockerfile"));
            $php_text = str_replace("REPLACE_PHP_VERSION", $php_version, $php_text);
            file_put_contents(base_path("docker/php/Dockerfile"), $php_text);

            $this->line("<info>docker directory copied!</info>");
        }

        if (file_exists(base_path(".gitignore"))) {
            $gitignore_text = file_get_contents(base_path(".gitignore"));
            if(strpos($gitignore_text, "/docker/mysql/storage/*") === false) {
                $gitignore_text = $gitignore_text . "\n" . "/docker/mysql/storage/*";
                file_put_contents(base_path(".gitignore"), $gitignore_text);

                $this->line("<info>add word to .gitignore!</info>");
            }
        }

        if (file_exists(base_path(".env"))) {
            $env_text = file_get_contents(base_path(".env"));
            $env_text = str_replace("APP_URL=http://localhost", "APP_URL=http://localhost:8888", $env_text);
            $env_text = str_replace("DB_HOST=127.0.0.1", "DB_HOST=mysql", $env_text);
            $env_text = str_replace("DB_DATABASE=homestead", "DB_DATABASE=db_wiz_" . $name, $env_text);
            $env_text = str_replace("DB_USERNAME=homestead", "DB_USERNAME=root", $env_text);
            $env_text = str_replace("DB_PASSWORD=secret", "DB_PASSWORD=password", $env_text);
            $env_text = str_replace("MAIL_HOST=smtp.mailtrap.io", "MAIL_HOST=smtp", $env_text);
            $env_text = str_replace("MAIL_PORT=2525", "MAIL_PORT=1025", $env_text);
            file_put_contents(base_path(".env"), $env_text);

            $this->line("<info>change .env!</info>");
        }
    }

}
