<?php

namespace Uehi\Larapack\Extensions\Database;

use Illuminate\Database\MySqlConnection;
use Uehi\Larapack\Extensions\Database\Schema\LarapackBlueprint;

class LarapackMySqlConnection extends MySqlConnection {

    /**
     * @return \Illuminate\Database\Schema\Builder
     */
    public function getSchemaBuilder()
    {
        $parentBuilder = parent::getSchemaBuilder();

        // larapack blueprintにする
        $parentBuilder->blueprintResolver(function($table, $callback) {
            return new LarapackBlueprint($table, $callback);
        });

        return $parentBuilder;
    }

}