# jsoninstallマニュアル

## 機能の概要

サイトの情報となるjsonを作成し、
```
(docker bash)$ php artisan larapack:jsoninstall
```
とすると、サイトの雛形（DB、管理画面、表画面）が作成される機能です。

## 注意点

- **新規プロジェクト作成用です。**  
既存プロジェクトにおいて使用すると余計なファイルが作成されたり、更新されたりするので、動かなくなる恐れがあります。  
新規以外で使用する場合はテスト的なプロジェクト上で使用してください。  
- **また、Laravel5.5でしか動作確認していません。**  
ご要望があれば5.6に対応するかも

- 問い合わせは佐藤まで

## 基本的な流れ

```
$ composer create-project "laravel/laravel=5.5.*" testproject
$ cd testproject/
$ git init
$ git add .
$ git commit -m "first commit"

[composer.json修正]
"repositories": [
    {
        "packagist": false
    },
    {
        "type": "composer",
        "url": "https://monitor.012grp.co.jp/satis"
    }
],

$ composer require uehi/larapack:1.1.*
$ php artisan larapack:dockerinstall
$ docker-compose build
$ docker-compose up -d
$ docker exec -it testproject_php bash

[larapack.jsonの作成]

(docker bash)$ php artisan larapack:jsoninstall
```
dockerinstallはdocker関連のファイルを配置してくれるものです。

## jsonファイルについて

larapack.jsonという名前で、プロジェクトのルートに配置してください。
```
testproject/larapack.json
```

```json
{
    "modules": [
        "migrateInstall",
        "larapackInstall",
        "habtm関係のマスタは先に記述すること",
        {
            "ckeditorInstall": {
                "version": "4.10.0",
                "type": "full",
                "dest": "/js/admin/"
            }
        },
        {
            "custom": [
                {
                    "table": "MasterArea",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"}
                    },
                    "title": "エリアマスタ",
                    "isMaster": true,
                    "hasSequence": true
                },
                {
                    "table": "MasterCategory",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"}
                    },
                    "title": "カテゴリマスタ",
                    "isMaster": true,
                    "value": ["サッカー", "野球", "バスケ"]
                },
                {
                    "table": "Test",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"},
                        "text": {"type": "text", "nullable": true, "comment": "テキスト"},
                        "password": {"type": "password", "default": "", "comment": "パスワード"},
                        "user_type": {"type": "select", "nullable": true, "comment": "立場", "dispList": "text", "values": "user_types", "empty": true, "dispSearch": true},
                        "master_area_id": {"type": "select", "nullable": true, "comment": "エリア", "dispList": "text", "hasOne": "MasterArea", "empty": true, "dispSearch": true},
                        "open_date": {"type": "selectDate", "nullable": true, "comment": "開設年月日", "options": {"minYear": 1900}, "dispList": "text", "dispSearch": true},
                        "start_date": {"type": "textDate", "default": "today", "comment": "開始年月日", "dispList": "text", "dispSearch": true},
                        "published": {"type": "textDate", "default": "today", "comment": "投稿日時", "dispList": "text", "dispSearch": true, "time": true},
                        "gender": {"type": "radio", "default": 0, "comment": "性別", "dispList": "text", "dispSearch": true, "values": "genders"},
                        "disp_top": {"type": "checkbox", "default": 0, "comment": "トップに表示するかどうか", "text": ["トップに表示する", "表示", "表示しない"], "dispList": "text", "dispSearch": true},
                        "image": {"type": "imageFile", "nullable": true, "comment": "画像"},
                        "file": {"type": "documentFile", "nullable": true, "comment": "ファイル"},
                        "map": {"type": "map", "comment": "位置情報"},
                        "MasterCategory": {"type": "belongsToMany", "comment": "カテゴリ"},
                        "admin_user_id": {"type": "select", "default": 0, "comment": "執筆者", "dispList": "text", "hasOne": "AdminUser", "dispSearch": true}
                    },
                    "title": "テスト",
                    "isFull": true,
                    "front": {"type": "basic"}
                },
                {
                    "table": "Setting",
                    "fileds": {
                        "Contact": {"type": "EmailMultiple", "comment": "問い合わせフォーム用管理者メール"},
                        "User": {"type": "EmailMultiple", "comment": "ユーザ登録フォーム用管理者メール"}
                    },
                    "title": "メール送信先設定",
                    "isMaster": true,
                    "isSingle": true
                },
                {
                    "table": "Contact",
                    "fileds": {
                        "name": {"type": "string", "default": "", "comment": "お名前", "dispList": "link"},
                        "name_kana": {"type": "katakana", "default": "", "comment": "フリガナ", "dispList": "text"},
                        "tel": {"type": "tel", "default": "", "comment": "電話番号", "dispList": "text"},
                        "email": {"type": "email", "default": "", "comment": "メールアドレス", "dispList": "text"},
                        "zip": {"type": "zip", "default": "", "comment": "郵便番号", "dispList": "text"},
                        "address": {"type": "string", "default": "", "comment": "市区町村"},
                        "note": {"type": "text", "nullable": true, "comment": "備考"}
                    },
                    "title": "お問い合わせ",
                    "isFull": true,
                    "front": {"type": "contact_form", "options": {"privacy": true, "confirm": true, "adminEmail": "Setting"}},
                    "ajaxzip3": {"field": ["zip", "", "address", "address"], "button": false}
                },
                {
                    "table": "User",
                    "fileds": {
                        "nickname": {"type": "string", "default": "", "comment": "ニックネーム", "dispList": "link"},
                        "username": {"type": "string", "default": "", "comment": "ログインID", "dispList": "link", "validate": ["unique", "regex:/^[a-zA-Z0-9-_]+$/"]},
                        "email": {"type": "email", "default": "", "comment": "メールアドレス", "dispList": "link", "validate": ["unique", "confirmed"]},
                        "password": {"type": "password", "default": "", "comment": "パスワード", "validate": ["confirmed", "create_required", "regex:/^[a-zA-Z0-9-_]+$/"]},
                        "mail_verified": {"type": "checkbox", "default": 0, "comment": "メール確認済みかどうか", "text": ["メール確認済み", "確認済み", "未確認"], "dispList": "text", "dispSearch": true}
                    },
                    "title": "ユーザ情報",
                    "isFull": true,
                    "front": {"type": "user_form", "options": {"privacy": true, "confirm": true, "adminEmail": "Setting89", "reCaptcha": true, "hideForm": ["mail_verified"]}}
                },
                {
                    "table": "MasterArticleCategory",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"}
                    },
                    "title": "カテゴリマスタ",
                    "isMaster": true,
                    "nested": true,
                    "slug": true
                },
                {
                    "table": "MasterTag",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"}
                    },
                    "title": "タグマスタ",
                    "isMaster": true,
                    "slug": true
                },
                {
                    "table": "Article",
                    "fileds": {
                        "title": {"type": "string", "default": "", "comment": "タイトル", "dispList": "link"},
                        "published": {"type": "textDate", "default": "today", "comment": "投稿日時", "dispList": "text", "dispSearch": true, "time": true},
                        "MasterTag": {"type": "belongsToMany", "comment": "タグ"},
                        "MasterArticleCategory": {"type": "nestedSelect", "selectField": "slug", "childUrl": "slug", "comment": "カテゴリ", "default": 0, "dispList": "text", "dispSearch": true},
                        "slug": {"type": "permalink", "parentUrl": "MasterArticleCategory", "default": "", "comment": "パーマネントリンク", "dispList": "text"},
                        "description": {"type": "text", "comment": "ディスクリプション"},
                        "body": {"type": "text", "comment": "本文", "ckeditor": true}
                    },
                    "title": "記事",
                    "isFull": true,
                    "isPrivatePublic": true,
                    "slug": "no-form"
                }
            ]
        },
        {
            "values": [
                {
                    "comment": "立場",
                    "name": "user_types",
                    "value": {
                        "1": "保護者",
                        "2": "保育士"
                    }
                },
                {
                    "comment": "性別",
                    "name": "genders",
                    "value": {
                        "1": "男性",
                        "2": "女性"
                    }
                }
            ]
        }
    ]
}
```

modulesに実行するモジュールを入れます。  
記述順に実行します。  
habtm関係のマスタは先に記述する必要があります。

### モジュールについて

- migrateInstall  
migrate:installを実行します。  
新規構築時以外は実行するとエラーになるので、削除かアンダーバーでも付けてください。

- larapackInstall  
larapack:installを実行します。  
また、const.phpとapp.phpを少し変更します。  
新規構築時以外は実行するとエラーになるので、削除かアンダーバーでも付けてください。

- ckeditorInstall  
ckeditorをwgetでダウンロードして設置してくれます。
デフォルト値は下記のとおり
```
"version": "4.10.0",
"type": "full",
"dest": "/js/admin/"
```

- custom  
メインモジュールです。テーブルを作成し、必要なプログラムを自動生成してくれます。詳細は後述

- values  
values.phpに値を追加します。customでselectなどの値にも指定できます。

### customの項目について

- table  
モデル名（単数、頭大文字）を設定します

- fileds  
各フィールドの情報です。詳細は後述

- title  
テーブル名です。コンテンツの名前に使われます。

- isFull  
larapackmake:viewでの引数と同じ。管理画面のindex.bladeやcreate.bladeを作成してくれる。  
デフォルト:true

- isSingle  
larapackmake:viewでの引数と同じ。設定画面向け  
デフォルト:false

- isMaster  
マスタテーブルの場合はtrueにすると、メニューの位置などを変えてくれる。  
デフォルト:false

- value  
マスタ用初期値Seedを作成する。マスタにしか（isMaster=true）使えません。

- hasSequence  
表示順機能を追加します。

- front  
表画面の機能を設定します。詳細は後述

- nested  
2階層カテゴリ作成する場合に設定

- slug  
slugルーティングする場合に設定

- isPrivatePublic  
公開・非公開テーブルに分ける場合に設定

- ajaxzip3  
ajaxzip3を使用する場合に設定

### filedsの項目について

- キー  
基本的にfield名になります。belongsToManyやEmailMultipleなどの場合は関連テーブル名が入ります。

- type  
fieldの型です。これにより、バリデーションも変わります。下記のtypeが使用できます。
```
string
text
password
select
selectDate
textDate
radio
checkbox
imageFile
documentFile
map
belongsToMany
email
EmailMultiple
katakana
hiragana
tel
zip
integer
unsignedInteger
```

- default  
default値です。これを設定すると必須入力になります。

- nullable  
null設定です。

- comment  
fieldのコメントです。フォーム等の項目名にも使用されます。

- dispList  
一覧画面に表示する場合設定します。textとlinkが設定できます。linkにすると、編集画面へのリンクが付きます。

- dispSearch  
一覧画面で検索条件のところに追加する場合はtrueを設定します。

- values  
radioとselectの場合において、values.phpに設定されている値を使用する際にその名前を設定します。

- hasOne  
radioとselectの場合において、マスタテーブルの値を使用する際にそのモデル名を設定します。

- empty  
selectの場合において、空を許容する場合にtrueにします。デフォルトでfalseです。

- options  
selectDateの場合において、minYearなどを設定できる。

- time  
textDateの場合において、時分秒を設定可にする場合にtrueにする。デフォルトfalse

- text  
checkboxの場合において、入力時、ON時、OFF時のテキストを設定する

- validate  
バリデーションを追加する場合に設定する。create_requiredで新規のみ必須のバリデーションを設定できる。

- selectField  
slug関連。調整中

- childUrl  
slug関連。調整中

- parentUrl  
slug関連。調整中

- ckeditor  
textの場合において、ckeditorを使用する場合に設定する。

### frontの項目について

- "type": "basic"  
一覧、検索、詳細、ページングの画面を生成。詳細はidでアクセスするタイプ。

- "type": "contact_form"  
お問い合わせフォーム。メール送信も。  
optionsで  
    - adminEmail  
    管理者メール送信先テーブルのモデル名  
    - privacy  
    プライバシーポリシー同意チェックボックス表示
    - confirm  
    trueで確認画面表示

- "type": "user_form"  
ユーザ登録の一連の画面生成。調整中
















