@extends('larapack::layouts.admin')

@section('css')
    @parent
@endsection
@section('cssBlock')
    @parent
@endsection
@section('js')
    @parent
    <script type="text/javascript">
        jQuery(function($){
            // buttonによりsubmitの対象を変える
            var previewAction = '{{ admin_url("/{$controllerNameSnake}/[id]preview") }}';
            var completeAction = '{{ admin_url("/{$controllerNameSnake}") }}';
            $('#formPreview').click(function(){
                @if (!empty($record->id))
                    $('form[name=crudForm]').attr('action', previewAction.replace('[id]', '{{$record->id}}/')).attr('target', '_blank').submit();
                @else
                    $('form[name=crudForm]').attr('action', previewAction.replace('[id]', '')).attr('target', '_blank').submit();
                @endif
            });
            $('#formComplete').click(function(){
                @if (!empty($record->id))
                    {{-- 編集の場合PUT --}}
                    $('form[name=crudForm]').prepend('<input name="_method" type="hidden" value="PUT">');
                    $('form[name=crudForm]').attr('action', completeAction + "/{{ $record->id }}").attr('target', '_self').submit();
                @else
                    {{-- 新規登録の場合 --}}
                    $('form[name=crudForm]').attr('action', completeAction).attr('target', '_self').submit();
                @endif
            });

            // .notEnterSubmitを除きENTERキーでsubmit
            $(document).on('keydown', 'input', function(e){
                if ($(this).hasClass('notEnterSubmit')) {
                    return;
                }
                e = e || window.event;
                if(e.keyCode == 13) {
                    $('#formComplete').click();
                }
            });
        });
    </script>
@endsection
@section('jsBlock')
    @parent
@endsection

@section('content')
    <h1>{{ $subject }}設定</h1>
    <h2>{{ $subject }}{{ empty($record->id) ? '登録' : ($actionName === 'show' ? '詳細' : '編集') }}</h2>

    {{ Form::model($record, ['url' => null, 'method' => 'POST', 'name' => 'crudForm', 'target' => '_self', 'files' => true]) }}
        <table class="table table-bordered form">
            @include(Larapack::util()->getPartialName('_form'))
        </table>
    {{ Form::close() }}

    <div>
        @if (!empty($formSettings['inputBack']) || $actionName === 'show')
            <a href="{{ admin_url("/{$controllerNameSnake}/?back=1") }}" class="btn btn-warning">戻る</a>
        @endif

        @if (!empty($formSettings['inputPreview']))
            @if ($actionName === 'show')
                <a href="{{ admin_url("/{$controllerNameSnake}/{$record->id}/preview") }}" class="btn btn-success" target="_blank">プレビュー</a>
            @else
                <a href="javascript:void(0);" class="btn btn-success" id="formPreview">プレビュー</a>
            @endif
        @endif

        @if ($actionName !== 'show')
            <a href="javascript:void(0);" class="btn btn-primary" id="formComplete">完了</a>
        @endif
    </div>
@endsection