<?php

use Illuminate\Support\Facades\Config;

if (!function_exists('admin_url')) {
    /**
     * admin prefixをつけたurlを返す
     * @param string $url
     * @return string
     */
    function admin_url($url = '')
    {
        return '/admin/' . trim($url, '/');
    }
}


if (!function_exists('get_current_route_names')) {
    /**
     * 現在のController名(**Controllerの**部分)とaction名を取得
     * @return array
     */
    function get_current_route_names()
    {
        $route = Illuminate\Support\Facades\Route::getCurrentRoute();
        if (empty($route)) {
            return [null, null];
        }
        $current = $route->getActionName();
        if ($current === 'Closure') {
            return [null, null];
        }
        $arr = explode('@', $current);
        $controller = !empty($arr[0]) ? $arr[0] : null;
        $action = !empty($arr[1]) ? $arr[1] : null;

        $controller = preg_replace('/.*\\\|Controller/', '', $controller);
        return [$controller, $action];
    }
}


if (!function_exists('req')) {
    /**
     * 必須アイコンを返す
     * @return mixed
     */
    function req()
    {
        return Uehi\Larapack\Facades\Larapack::util()->getRequiredIcon();
    }
}


if (!function_exists('mb_trim')) {
    /**
     * 全角スペースもtrim
     * @return mixed
     */
    function mb_trim($text)
    {
        $text = preg_replace('/^[ 　\t\n\r\0\x0B]+/u', '', $text);
        $text = preg_replace('/[ 　\t\n\r\0\x0B]+$/u', '', $text);
        return $text;
    }
}


if (!function_exists('upload_tmp_dir')) {
    /**
     * ファイルアップロード一時パス取得
     * @return mixed
     */
    function upload_tmp_dir()
    {
        return public_path('storage/' . app('config')->get('const.uploads.tmp_dir'));
    }
}
