<?php

namespace Uehi\Larapack;

use Collective\Html\FormBuilder;
use Illuminate\Support\Facades\Session;

class Larapack
{
    private $util;
    private $form;
    private $csv;
    private $multiBlock;

    /**
     * Larapack constructor.
     */
    public function __construct()
    {
        $this->util = new Util();
        $this->form = new Form();
        $this->csv = new Csv();
        $this->multiBlock = new MultiBlock();
    }

    /**
     * 汎用処理クラス
     * @return Util
     */
    public function util()
    {
        return $this->util;
    }

    /**
     * laravelcollective::formのラッパークラス
     * @return Form
     */
    public function form()
    {
        return $this->form;
    }

    /**
     * CSV生成クラス
     * @return Form
     */
    public function csv()
    {
        return $this->csv;
    }

    /**
     * N段処理クラス
     * @return MultiBlock
     */
    public function multiBlock()
    {
        return $this->multiBlock;
    }

    /**
     * cssファイルの読込(<link rel="stylesheet" href="~~">)するsrcを配列でまとめておく
     * 重複でappendしないように
     * @var array
     */
    private $cssFiles = [];

    /**
     * jsファイルの読込(<script src='~~'></script>)するsrcを配列でまとめておく
     * 重複でappendしないように
     * @var array
     */
    private $jsFiles = [];

    /*
    |--------------------------------------------------------------------------
    | flash
    |--------------------------------------------------------------------------
    */

    /**
     * 共通のsession::flashをset
     * @param $message
     */
    public function setFlash($message)
    {
        Session::flash('message', $message);
    }

    /**
     * 共通のsession::flashを出す
     * @param string $type
     * @return string
     */
    public function flash($type = 'danger')
    {
        if (Session::has('message')) {
            return '<div class="alert alert-' . $type . '">' . Session::get('message') . '</div>';
        }
        return '';
    }

    /*
    |--------------------------------------------------------------------------
    | js, css読込制御系
    |--------------------------------------------------------------------------
    */

    /**
     * cssをappendする
     * 一度追加したものは追加しない
     */
    public function appendCss($src)
    {
        if (!in_array($src, $this->cssFiles)) {
            app('view')->startSection('css');
            echo "<link rel='stylesheet' href='{$src}'>";
            app('view')->appendSection();
        }
    }

    /**
     * jsをappendする
     * 一度追加したものは追加しない
     */
    public function appendJs($src)
    {
        if (!in_array($src, $this->jsFiles)) {
            app('view')->startSection('js');
            echo "<script src='{$src}'></script>";
            app('view')->appendSection();
        }
    }

    /**
     * css記述をappendする
     */
    public function appendCssBlock($css)
    {
        app('view')->startSection('cssBlock');
        echo $css;
        app('view')->appendSection();
    }

    /**
     * js記述をappendする
     */
    public function appendJsBlock($js)
    {
        app('view')->startSection('jsBlock');
        echo $js;
        app('view')->appendSection();
    }

    /**
     * jsをイベントなどでappendする
     */
    public function appendJsOnEvent($src, $onload = false)
    {
        $script = '
        {
            var s = document.createElement("script");
            s.type = "text/javascript";
            s.src = "' . $src . '";';
        if(!empty($onload)) {
            $script .= '
            s.onload = ' . $onload . ';';
        }
        $script .= '
            document.getElementsByTagName("head")[0].appendChild(s);
        }';
        return $script;
    }

}