<?php
// 1対多の場合の記述例
?>
{{-- blockId, keyが渡される --}}
<table class="table table-bordered multiBlock">
    <tr>
        <th>
            {{ Larapack::multiBlock()->up($blockId) }}
            &nbsp;
            {{ Larapack::multiBlock()->down($blockId) }}

            {{-- id --}}
            {{ Larapack::form()->hidden("example_details[{$key}][id]") }}
            {{-- sequence --}}
            {{ Larapack::form()->hidden("example_details[{$key}][sequence]") }}
        </th>
        <td>
            <div class="form-inline">
                <label>
                    名称
                    {{ Larapack::form()->text("example_details[{$key}][title]", null, ['class' => 'form-control']) }}
                </label>
                {{ Larapack::form()->error("example_details[{$key}][title]") }}
            </div>
            <div class="form-inline">
                <label>
                    画像
                    {{ Larapack::form()->imageFile("example_details[{$key}][image]", [], ['width' => '160px']) }}
                </label>
            </div>
            <div class="form-inline">
                <label>
                    本文
                    {{ Larapack::form()->textarea("example_details[{$key}][textarea]", null, ['class' => 'form-control'], ['src' => url('/js/ckeditor/ckeditor.js'), 'class' => 'ckeditor_on']) }}
                </label>
                {{ Larapack::form()->error("example_details[{$key}][textarea]") }}
            </div>
        </td>
        <td class="w75" align="center">
            {{ Larapack::multiBlock()->delete($blockId) }}
        </td>
    </tr>
</table>
