<?php
namespace Uehi\Larapack\Listeners;

use App\Models\AdminUser;
use Carbon\Carbon;
use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\Auth;

class LoginSuccess
{
    public function handle(Login $event)
    {
        // admin userのみ
        $user = Auth::guard('admin')->user();
        if (!empty($user) && $user instanceof AdminUser) {
            $user->last_login = Carbon::now();
            $user->timestamps = false;
            $user->save();
        }
    }
}