<?php

namespace Uehi\Larapack\Extensions\Database\Schema;

use Illuminate\Database\Schema\Blueprint;

class LarapackBlueprint extends Blueprint {

    /**
     * 'public'カラム作成
     * @return mixed
     */
    public function publicFlag()
    {
        return $this->unsignedSmallInteger('public')->default(2);
    }

    /**
     * {created, updated, deleted}_at/idを作成
     */
    public function allTimestamps()
    {
        $this->timestamps();
        $this->softDeletes();
        $this->unsignedInteger('created_id')->nullable();
        $this->unsignedInteger('updated_id')->nullable();
        $this->unsignedInteger('deleted_id')->nullable();
    }

}