<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Console\Command;

class CrudMakeCommand extends Command
{
    /**
     * The console command signature.
     *   full: 全てのviewを外出しする
     *   single: 設定画面などフォーム1画面の機能を出したい場合
     * @var string
     */
    protected $signature = 'larapackmake:crud {name : The name of model class.} {--full : Whether creating all view.} {--single : in case form page only.}';

    /**
     * 説明
     * @var string
     */
    protected $description = 'Create Larapack crud';

    /**
     * Execute
     * @return void
     */
    public function handle()
    {
        $name = trim($this->input->getArgument('name'));
        $isFull = $this->option('full');
        $isSingle = $this->option('single');

        $this->createFiles($name, $isFull, $isSingle);
    }

    /**
     * 必要なファイルを作成
     * @param $name
     * @param $isFull
     * @param $isSingle
     */
    public function createFiles($name, $isFull, $isSingle)
    {
        $this->call('larapackmake:model', ['name' => $name]);
        $this->call('larapackmake:request', ['name' => $name]);
        $this->call('larapackmake:controller', ['name' => $name, '--single' => $isSingle]);
        $this->call('larapackmake:view', ['name' => $name, '--full' => $isFull, '--single' => $isSingle]);
    }

}
