<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;
use Illuminate\Filesystem\Filesystem;

/**
 * ファイルアップロードのtmp領域内ファイルを全削除するコマンド
 * Class CleanUploadsCommand
 * @package Uehi\Larapack\Commands
 */
class CleanUploadsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'upload:clean';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'remove all files in upload tmp directory';

    /**
     * Execute the console command.
     * @return mixed
     * @throws \ReflectionException
     */
    public function handle()
    {
        $tmp = Config::get('const.uploads.tmp_dir');
        $publicTmpDir = storage_path("app/public/{$tmp}");
        $privateTmpDir = storage_path("app/{$tmp}");

        $file = new Filesystem;
        $file->cleanDirectory($publicTmpDir);
        $file->cleanDirectory($privateTmpDir);
    }

}
