<?php

namespace Uehi\Larapack\Commands;

use Illuminate\Foundation\Console\RequestMakeCommand as RequestMakeCommandOriginal;
use Illuminate\Support\Facades\DB;

class RequestMakeCommand extends RequestMakeCommandOriginal
{

    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'larapackmake:request';

    /**
     * Get the desired class name from the input.
     *
     * @return string
     */
    protected function getNameInput()
    {
        return trim($this->argument('name')) . 'Request';
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return __DIR__.'/stubs/request.stub';
    }

    /**
     * Replace the class name for the given stub.
     *
     * @param  string  $stub
     * @param  string  $name
     * @return string
     */
    protected function replaceClass($stub, $name)
    {
        $stub = parent::replaceClass($stub, $name);

        $class = str_replace($this->getNamespace($name).'\\', '', $name);
        $class = str_replace('Request', '', $class);
        $table = str_plural(snake_case($class));

        // DummySnakeClass置換(Example => example)
        $stub = str_replace('DummySnakeClass', snake_case($class), $stub);

        // 現在tableがある場合rules配列とattributes配列にカラム名を入れる
        $columnStr = '';
        if (DB::select("show tables like '{$table}';")) {
            $ignores = [
                'id',
                'created_at',
                'updated_at',
                'deleted_at',
                'created_id',
                'updated_id',
                'deleted_id',
            ];
            $columns = DB::select("show columns from {$table};");
            foreach ($columns as $column) {
                if (!in_array($column->Field, $ignores)) {
                    if (!empty($columnStr)) {
                        $columnStr .= "\n";
                    }
                    $columnStr .= "            '{$column->Field}' => '',";
                }
            }
        }
        $stub = str_replace('DummyColumns', $columnStr, $stub);

        return $stub;
    }
}
