<?php

namespace Uehi\Larapack\Middleware;

use Closure;
use Illuminate\Support\Facades\Config;

class RequestFormatMiddleware
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $params = $request->all();

        if (!empty($params)) {
            $ret = $this->trimAll($params);
            $request->merge($ret);
        }

        return $next($request);
    }

    /**
     * 配列の文字列を全trim
     * @param $array
     * @return mixed
     */
    private function trimAll($array)
    {
        array_walk_recursive($array, function(&$val, $key){
            $val = is_string($val) ? mb_trim($val) : $val;
        });
        return $array;
    }

}
