<?php
/**
 * routes(主に管理画面)
 */



// admin
Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => 'web'], function() {
    // login, logout
    Route::get('login', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@showLoginForm')->name('login');
    Route::post('login', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@login')->name('login');
    Route::get('logout', 'Uehi\Larapack\Controllers\Admin\Auth\LoginController@logout')->name('logout');

    // その他(認証必要)
    Route::group(['middleware' => 'auth.admin'], function() {
        // admin_users
        Route::resource('admin_users', 'App\Http\Controllers\Admin\AdminUsersController');

        // admin controllers
        $adminControllerPath = app_path('Http/Controllers/Admin');
        if (file_exists($adminControllerPath)) {
            $controllers = File::glob("{$adminControllerPath}/*Controller.php");
            if (!empty($controllers)) {
                foreach ($controllers as $controller) {
                    $name = str_replace('Controller.php', '', basename($controller));
                    if ($name !== 'Home') { // HomeControllerは除外
                        $namespace = 'App\Http\Controllers\Admin\\' . $name . 'Controller';
                        $snake = snake_case($name);
                        Route::resource($snake, $namespace);
                        // preview method用意している場合preview routingする
                        if (method_exists(new $namespace, 'preview')) {
                            Route::post("/{$snake}/preview", "{$namespace}@preview")->name("{$snake}.input_preview");
                            Route::get("/{$snake}/{" . str_singular($snake) . "}/preview", "{$namespace}@preview", 'id')->name("{$snake}.preview");
                        }
                    } else {
                        // homeは最後に登録する
                        $isHomeExists = true;
                    }
                }
            }
        }

        // larapack
        Route::patch('/larapack/changePublic', 'Uehi\Larapack\Controllers\Admin\LarapackController@changePublic')->name('larapack.change_public');
        Route::patch('/larapack/changeSequence', 'Uehi\Larapack\Controllers\Admin\LarapackController@changeSequence')->name('larapack.change_sequence');

        // home
        if (!empty($isHomeExists)) {
            Route::get('/', 'App\Http\Controllers\Admin\HomeController@index')->name('home');
        } else {
            Route::get('/', 'Uehi\Larapack\Controllers\Admin\HomeController@index')->name('home');
        }
    });
});

// admin以外
Route::group(['middleware' => 'web'], function () {
    // uploader
    Route::post('/uploader/upload', 'Uehi\Larapack\Controllers\UploaderController@upload')->name('uploader.upload');
    Route::get('/uploader/readTmp/{filename}', 'Uehi\Larapack\Controllers\UploaderController@readTmp')->name('uploader.read_tmp')->where('filename', '(.+)');
    Route::get('/uploader/read/{model}/{id}/{column}', 'Uehi\Larapack\Controllers\UploaderController@read')->name('uploader.read');
});
