<?php

namespace Uehi\Larapack\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Validator;
use ReflectionClass;

class UploaderController extends Controller
{

    /**
     * アップロード処理
     * post
     *      image(カラム名)
     *      model
     *      request
     *      column
     *      image_options
     */
    public function upload()
    {
        // validate
        // もともとのFormRequestからファイルアップcolumnのruleのみを抜粋する
        $params = Request::all();

        // hasManyかどうか
        $hasMany = false;
        if (preg_match('/^(.+)\[([0-9]+)\]\[(.+)\]$/', $params['column'], $m)) {
            $hasMany = true;
            $childProp = $m[1];
            $childNum = $m[2];
            $childColumn = $m[3];
        }

        $formRequest = $params['request'];
        $formRequest = new $formRequest;
        $column = $params['column'];
        $rules = $formRequest->rules();
        if ($hasMany) {
            $ruleKey = "{$childProp}.*.{$childColumn}";
            $rules = !empty($rules[$ruleKey]) ? [$ruleKey => $rules[$ruleKey]] : [];
        } else {
            $rules = !empty($rules[$column]) ? [$column => $rules[$column]] : [];
        }
        $validator = Validator::make($params, $rules, $formRequest->messages(), $formRequest->attributes());

        // view
        if (isset($params['image_options'])) {
            // 画像
            $viewName = 'larapack::uploader.image';
            $imageOptions = is_array($params['image_options']) ? $params['image_options'] : json_decode($params['image_options'], true);
            $viewData = [
                'column' => $column,
                'filename' => null,
                'imageOptions' => $imageOptions,
            ];
        } else {
            // ファイル
            $viewName = 'larapack::uploader.document';
            $viewData = [
                'column' => $column,
                'filename' => null,
            ];
        }

        // validate
        if ($validator->fails()) {
            app('view')->share('errors', $validator->messages()); // shareに登録されないので手動で
            return view($viewName, $viewData)->withErrors($validator->messages());
        } else {
            // ファイルをtmp領域に移す
            $modelName = $params['model'];
            $model = new $modelName;
            if ($hasMany) {
                $childModelName = (new ReflectionClass($model->$childProp()->getRelated()))->getName();
                $childModel = new $childModelName;
                $viewData['filename'] = $childModel->uploadToTmp($column);
            } else {
                $viewData['filename'] = $model->uploadToTmp($column);
            }

            return view($viewName, $viewData);
        }

    }

}
