function MultiBlock(addId, templateId, sequenceField) {

    this.addId = addId;
    this.templateId = templateId;

    // key(連番を求める)
    var key = 0;
    jQuery(document).ready(function(){
        jQuery('#' + addId).children('div').each(function(){
            var id = jQuery(this).attr('id').split('___')[1];
            if(key <= parseInt(id)) key = parseInt(id);
        });

        // template用のフォームは送信されないようにdisableに
        jQuery("#" + templateId).find(':input').attr('disabled', 'disabled');

        // formのsubmit時に空のブロックは送信しない処理 ----------
        var form = jQuery('#' + addId).closest('form');
        form.submit(function(){
            // 空のブロックをdisableに
            jQuery('#' + addId).children('div').each(function(){
                var isEmpty = true;
                var inputs = jQuery(this).find(':input');
                (function(){
                    inputs.each(function(){
                        if(jQuery(this).val() != '') isEmpty = false;
                    });
                })();
                if(isEmpty){
                    inputs.attr('disabled', 'disabled');
                }
            });

            // 並び順をパラメータに埋め込み
            if (sequenceField && sequenceField !== 'id') {
                var i = 1;
                jQuery("input[name*='\[" + sequenceField + "\]']").each(function () {
                    var name = $(this).attr('name');
                    if (!name.match(/NNN/) && !$(this).is(':disabled')) {
                        $(this).val(i);
                        i += 1;
                    }
                });
            }

            return true;
        });
        // document.form.submitのボタンやリンクは上記イベントに反応しないのでここでbindする
        jQuery('[href*=\'document\.' + form.attr('name') + '\.submit\']').each(function(){
            jQuery(this).attr('href', 'javascript:void(0);');
            jQuery(this).click(function(){
                form.submit();
            });
        });
        jQuery('[onclick*=\'document\.' + form.attr('name') + '\.submit\']').each(function(){
            jQuery(this).attr('onclick', '');
            jQuery(this).click(function(){
                form.submit();
            });
        });
    });

    /**
     * ブロックを追加
     */
    this.addForm = function() {

        // キーの値としてunixtimeを取得する
        //var key = new Date().getTime();
        key = key + 1;

        // テンプレートから追加する要素を生成する
        var html = jQuery("#" + this.templateId).html();

        html = html.replace(/NNN/g, key);
        obj = jQuery(html);

        // フォームがdisableなので、enableに変える
        obj.find(':input').removeAttr('disabled');

        // 子divを親div内に追加
        jQuery("#" + this.addId).append(obj);

        this.initCkEditor();
    };

    /**
     * CK EDITORを活性化 活性化する要素はクラスに「ckeditor_on」が付与されているもの
     */
    this.initCkEditor = function() {

        jQuery("#" + addId + " .ckeditor_on").each(function() {
            var t = jQuery(this).attr("name");

            // CkEditor化されていなければ、しておく
            if (!CKEDITOR.instances[t]) {
                CKEDITOR.replace(t);
            }
        });
    }

    /**
     * CK EDITORを非活性化
     */
    this.destroyCkEditor = function(target_id) {

        // CkEditorを破棄する
        jQuery("#" + target_id + " .ckeditor_on").each(function() {
            var ckid = jQuery(this).attr("name");
            CKEDITOR.instances[ckid].destroy();
        });

    }

    /**
     * CK EDITORを非活性化
     */
    this.deleteBlock = function(target_id) {

        if (!window.confirm('ブロックを削除してもよろしいですか？\n※入力中のテキストは破棄されます。'))
            return;

        jQuery("#" + target_id).remove();

    }

    /**
     * 並び替え（対象要素を上に）
     */
    this.up = function(target_id) {
        var mb = this; // 後のeach内で使いたいため退避しておく
        var prev;

        jQuery("#" + addId).children().each(function() {
            var current = jQuery.trim(jQuery(this).attr("id"));

            if (current == target_id) {

                // CkEditorを有効にしたまま移動させるとおかしくなるので一旦オフにする
                mb.destroyCkEditor(current);
                mb.destroyCkEditor(prev);

                jQuery("#" + current).after(jQuery("#" + prev));

                return (false);
            }

            prev = current;
        });

        this.initCkEditor();
    }

    /**
     * 並び替え（対象要素を下に）
     */
    this.down = function(target_id) {
        var mb = this; // 後のeach内で使いたいため退避しておく
        var prev;
        var hit;

        jQuery("#" + addId).children().each(function() {

            var current = jQuery.trim(jQuery(this).attr("id"));

            if (current == target_id) {
                hit = true;

                // CkEditorを有効にしたまま移動させるとおかしくなるので一旦オフにする
                mb.destroyCkEditor(current);
                mb.destroyCkEditor(prev);

            } else if (hit) {

                jQuery("#" + current).after(jQuery("#" + prev));

                return (false);
            }

            prev = current;
        });

        this.initCkEditor();

    }

}
