<?php
/**
 * model
 * request
 * column
 * fileClass
 * divClass
 * imageOptions
 */
$uploadUrl = url('/uploader/upload');
if (preg_match('/^(.+)\[([0-9]+)\]\[(.+)\]$/', $column, $m)) {
    $deleteName = "{$m[1]}[{$m[2]}][{$m[3]}" . app('config')->get('const.uploads.delete_suffix') . "]";
} else {
    $deleteName = $column . app('config')->get('const.uploads.delete_suffix');
}
?>

<script type="text/javascript">
    jQuery(function($) {
        var column = '{{ $column }}';
        var fileSel = '.{{ $fileClass }}';
        var divSel = '.{{ $divClass }}';
        var uploadUrl = '{{ $uploadUrl }}';
        var imageOptions = JSON.stringify({!! json_encode($imageOptions) !!});
        var loader = '<img src="{{ url('/larapack/img/loader_small.gif') }}">';

        // 写真が選択されたときにリサイズ
        $(document).on('change', fileSel, function() {
            // ファイルがない場合なにもしない
            if (this.files.length <= 0) {
                return;
            }
            var that = this;
            var fileObj = $(this);
            var divObj = $(this).prev(divSel);

            divObj.html(loader);
            // submitされないように全てのボタンはdisable
            $('.btn').attr('disabled', true);

            $(this).inputFileResizer({
                onStart: function() {
                    //
                },
                onComplete: function(dataURL, dispImg, file) {
                    // ajaxでファイルのみPOST
                    var fd = new FormData();
                    var name = column;
                    if (!dataURL && !dispImg && !file) {
                        // gifの場合リサイズ処理せず全てnullで返ってくる
                        var files = that.files;
                        $.each(files, function(i, file) {
                            fd.append(name, file);
                        });
                    } else {
                        fd.append(name, dataURL);
                    }
                    // その他必要なもの
                    fd.append('model', '{{ $model }}');
                    fd.append('request', '{{ $request }}');
                    fd.append('column', column);
                    fd.append('image_options', imageOptions);
                    // csrf
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    })
                    $.ajax({
                        url: uploadUrl,
                        type: 'POST',
                        data: fd,
                        contentType: false,
                        processData: false,
                        cache : false,
                        success: function(html) {
                            divObj.html(html);
                            // input type fileを空にするため置き換え
                            fileObj.replaceWith(fileObj = fileObj.clone(true));
                            fileObj.val('');
                            $('.btn').attr('disabled', false);
                        },
                        error: function(obj) {
                            if (obj.responseJSON[column]) {
                                obj.responseJSON[column].forEach (function(val, i) {
                                    divObj.html('<div class="error-message">' + val + '</div>');
                                });
                                $('.btn').attr('disabled', false);
                            }

                            // reset
                            fileObj.replaceWith(fileObj = fileObj.clone(true));
                            fileObj.val('');
                        }
                    });
                },
                onError: function(error) {
                    divObj.html('<div class="error-message">jpg,gif,pngのみアップロードできます</div>');
                    $('.btn').attr('disabled', false);
                }
            });
        });

        // 画像削除処理
        $(document).on('click', '.resizeAjaxImageDelBtn', function(){
            var container = $(this).closest(divSel);
            var fileObj = container.next('input:file');
            container.html('{{ Form::hidden($deleteName, 1) }}');
            fileObj.replaceWith(fileObj = fileObj.clone(true));
            fileObj.val('');
            return false;
        });

    });
</script>