<?php
/**
 * model
 * request
 * column
 * fileClass
 * divClass
 */
$uploadUrl = url('/uploader/upload');
if (preg_match('/^(.+)\[([0-9]+)\]\[(.+)\]$/', $column, $m)) {
    $deleteName = "{$m[1]}[{$m[2]}][{$m[3]}" . app('config')->get('const.uploads.delete_suffix') . "]";
} else {
    $deleteName = $column . app('config')->get('const.uploads.delete_suffix');
}
?>

<script type="text/javascript">
    jQuery(function($) {
        var column = '{{ $column }}';
        var fileSel = '.{{ $fileClass }}';
        var divSel = '.{{ $divClass }}';
        var uploadUrl = '{{ $uploadUrl }}';
        var loader = '<img src="{{ url('/larapack/img/loader_small.gif') }}">';

        $(document).on('change', fileSel, function() {
            // ファイルがない場合なにもしない
            if (this.files.length <= 0) {
                return;
            }
            var that = this;
            var fileObj = $(this);
            var divObj = $(this).prev(divSel);

            divObj.html(loader);
            // submitされないように全てのボタンはdisable
            $('.btn').attr('disabled', true);

            // ajaxでファイルのみPOST
            var fd = new FormData();
            var name = column;
            var files = that.files;
            $.each(files, function(i, file) {
                fd.append(name, file);
            });
            // その他必要なもの
            fd.append('model', '{{ $model }}');
            fd.append('request', '{{ $request }}');
            fd.append('column', column);
            // csrf
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
            $.ajax({
                url: uploadUrl,
                type: 'POST',
                data: fd,
                contentType: false,
                processData: false,
                cache : false,
                success: function(html) {
                    divObj.html(html);
                    // input type fileを空にするため置き換え
                    fileObj.replaceWith(fileObj = fileObj.clone(true));
                    fileObj.val('');
                    $('.btn').attr('disabled', false);
                },
                error: function(obj) {
                    if (obj.responseJSON[column]) {
                        obj.responseJSON[column].forEach (function(val, i) {
                            divObj.html('<div class="error-message">' + val + '</div>');
                        });
                        $('.btn').attr('disabled', false);
                    }

                    // reset
                    fileObj.replaceWith(fileObj = fileObj.clone(true));
                    fileObj.val('');
                }
            });
        });

        // 削除処理
        $(document).on('click', '.resizeAjaxImageDelBtn', function(){
            var container = $(this).closest(divSel);
            var fileObj = container.next('input:file');
            container.html('{{ Form::hidden($deleteName, 1) }}');
            fileObj.replaceWith(fileObj = fileObj.clone(true));
            fileObj.val('');
            return false;
        });

    });
</script>