@extends('larapack::layouts.admin')


@section('content')

    <h1>{{ $subject }}設定</h1>
    <h2>
        登録されている{{ $subject }}の一覧です
        <a href="{{ admin_url("/{$controllerNameSnake}/create") }}" class="btn btn-primary">新規登録</a>
    </h2>

    <div class="panel panel-default">
        <div class="panel-body">
            {{ Form::open(['method' => 'GET']) }}
                @include(Larapack::util()->getPartialName('_search'))

                <a href="javascript:void(0);" class="btn btn-default adminIndexClearForm">クリア</a>
                {{ Form::submit('検索', array('class' => 'btn btn-primary')) }}
            {{ Form::close() }}
        </div>
    </div>

    <div class="pagenation-wrapper form-inline">
        {{ Larapack::util()->selectLimit() }}
        {{ Larapack::util()->paginator($records) }}
    </div>

    <div class="text-right">
        該当 {{ $records->total() }}件
    </div>

    <table class="table table-bordered list">
        @include(Larapack::util()->getPartialName('_list'))
    </table>

    <div class="pagenation-wrapper">
        {{ Larapack::util()->paginator($records) }}
    </div>

@endsection