<!DOCTYPE html>
<html lang="ja">
<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="imagetoolbar" content="no" />
    <meta name="ROBOTS" content="noindex, nofollow" />
    <title>管理画面｜{{ config('app.name') }}</title>


    {{-- this app css --}}
    <link rel="stylesheet" href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/non-responsive.css') }}">
    <link rel="stylesheet" href="//fonts.googleapis.com/earlyaccess/roundedmplus1c.css">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/theme.min.css') }}">
    <link rel="stylesheet" href="{{ url('/larapack/css/admin/admin.css') }}">

    @section('css')
    @show
    @section('cssBlock')
    @show

    {{-- jQuery --}}
    <script src='//ajax.googleapis.com/ajax/libs/jquery/2.2.2/jquery.min.js'></script>
    <script src='//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js'></script>
    <script src='//ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js'></script>

    {{-- 共通scripts --}}
    @include('larapack::partials._common_js')

    @section('js')
    @show
    @section('jsBlock')
    @show

</head>

<body>

@if (!empty($auth)) {{-- ログイン済み --}}

    <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
        <div class="container-fluid">
            <div class="navbar-header">
                <a href="{{ url('/admin/') }}" class="navbar-brand">{{ config('app.name') }}</a>
            </div>

            <ul class="nav navbar-nav navbar-left">
                <li><a href="{{ url('/') }}" target="_blank">サイトを表示</a></li>
            </ul>
            <ul class="nav navbar-nav navbar-right">
                <li class="dropdown">
                    <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="glyphicon glyphicon-user icon-white"></i> {{ $auth['title'] }} 様 <span class="caret"></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a href="{{ url('/admin/logout') }}"><i class="glyphicon glyphicon-off icon-black"></i> ログアウト</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>

    <div class="container-fluid">
        <div class="sidebar">
            @include('larapack::partials.admin._menu')
        </div>

        <div class="main">
            {!! Larapack::flash('warning') !!}
            @yield('content')
        </div>
    </div>

@else {{-- ログイン画面 --}}

    <div class="main-login">
        <div class="panel panel-default center-block">
            <div class="panel-heading">
                <h3 class="panel-title text-center">
                    {{ config('app.name') }}
                </h3>
            </div>
            <div class="panel-body loginBox">
                {!! Larapack::flash() !!}
                @yield('content')
            </div>
        </div>
    </div>

@endif

</body>
</html>
