<?php
namespace Cbase\View\Helper;
use Cake\View\Helper;
use Cake\View\View;
use Cake\Core\Configure;
use Cake\ORM\TableRegistry;
use Cake\Utility\Inflector;
use Cake\View\Form\NullContext;
use Cake\I18n\Date;
use Cake\I18n\Time;
use Cake\Utility\Hash;
/**
 * MultiBlockHelper
 *
 * @author ueno
 *
 * @property HtmlHelper $Html
 * @property FormHelper $Form
 */
class MultiBlockHelper extends Helper
{

    /**
     * @var array helpers
     */
    public $helpers = ['Form', 'Html', 'Cbase.Minify'];

    /**
     * @var string js内でのMultiBlockオブジェクト名
     */
    private $mbObjName = "mb";

    /**
     * n段を表示
     * @param string $template テンプレートファイル
     * @param array|null $datas 初期表示させるデータ // entityの配列
     * @param boolean $isConfirm 確認画面の場合trueにする,trueにするとボタンや並び替えが非表示になる
     * @param array $options
     *      array $sort どの順番で表示するか ['id' => 'asc']
     *      boolean $wysiwyg n段内部にwysiwyg利用する場合はtrueにする
     *      boolean $firstForm データが1件もない場合に1つフォームを表示させておくか
     */
    public function show($template, $datas = [], $isConfirm = false, array $options = [])
    {
        $defaults = [
            'sort' => [],
            'wysiwyg' => false,
            'firstForm' => false
        ];
        $options = array_merge($defaults, $options);

        // 設定値(同一ページで複数のmultiblockができるようにユニークに)
        // model
        $paths = explode(DS, $template);
        $templateName = $paths[count($paths) - 1];
        // adding id
        $addId = "{$templateName}_mainDetail";
        // templateid
        $templateId = "{$templateName}_template";
        // blockIdFormat(jsで___でsplitするため$templateNameに___が入らない前提)
        $blockIdFormat = "{$templateName}___%s";

        // $this->mbObjNameもユニークに
        $this->mbObjName = "{$templateName}_mb";

        // 出力文字列
        $ret = '';

        // 入力画面のみ
        if (!$isConfirm) {
            // js読み込み
            $ret .= $this->Html->script('/cbase/js/multi_block', ['block' => true]);
            $wysiwygInit = ($options['wysiwyg']) ? "jQuery.event.add(window, 'load', function(){ {$this->mbObjName}.initCkEditor() });" : '';
            $ret .= $this->Html->scriptBlock($this->Minify->scriptBlock("
                // 段落追加
                var {$this->mbObjName}  = new MultiBlock('{$addId}', '{$templateId}');
                {$wysiwygInit}
            "), ['block' => true]);

            // 複製用のテンプレート
            $ret .= "<div id='{$templateId}' style='display: none;'>";
            $ret .= $this->_View->element($template, ['key' => 'NNN', 'blockId' => sprintf($blockIdFormat, 'NNN')]);
            $ret .= '</div>';
        }

        // メイン部分
        $ret .= "<div id='{$addId}'>";
        // フォーム値がなければ一つだけ表示する
        if (empty($datas) && $options['firstForm']) {
            $datas[0] = true;
        }
        // 値をループして持ち回す
        if (!empty($datas)) {
            if (!empty($options['sort'])) {
                $datas = $this->_sort($datas, $options['sort']);
            }
            foreach ($datas as $key => $val) {
                if ($key === 'NNN') {
                    continue; //型まで比較
                }
                $ret .= $this->_View->element($template, ['key' => $key, 'blockId' => sprintf($blockIdFormat, $key)]);
            }
        }
        $ret .= '</div>';

        // ボタン
        if (!$isConfirm) {
            $ret .= $this->Html->link('ブロックを追加', 'javascript:void(0);', [
                'onclick' => "{$this->mbObjName}.addForm();return false;",
                "id" => "addButton",
                "class" => "btn btn-primary btn-sm"
            ]);
        }

        echo $ret;

    }

    /**
     * 上に移動
     * @param string $blockId ブロックID
     * @param boolean $isConfirm 確認画面の場合trueにする,trueにすると表示しない
     * @param boolean $scriptOnly trueにするとjsのみ返す
     * @return mixed|void
     */
    public function up($blockId, $isConfirm = false, $scriptOnly = false)
    {
        if ($isConfirm) {
            return;
        }
        $script = "javascript:{$this->mbObjName}.up('{$blockId}');";
        if ($scriptOnly) {
            return $script;
        } else {
            echo $this->Html->link('↑上に移動', $script, ['class' => 'btn btn-default btn-sm']);
        }
    }

    /**
     * 下に移動
     * @param string $blockId ブロックID
     * @param boolean $isConfirm 確認画面の場合trueにする,trueにすると表示しない
     * @param boolean $scriptOnly trueにするとjsのみ返す
     * @return mixed|void
     */
    public function down($blockId, $isConfirm = false, $scriptOnly = false)
    {
        if ($isConfirm) {
            return;
        }
        $script = "javascript:{$this->mbObjName}.down('{$blockId}');";
        if ($scriptOnly) {
            return $script;
        } else {
            echo $this->Html->link('↓下に移動', $script, ['class' => 'btn btn-default btn-sm']);
        }
    }

    /**
     * 削除
     * @param string $blockId ブロックID
     * @param boolean $isConfirm 確認画面の場合trueにする,trueにすると表示しない
     * @param boolean $scriptOnly trueにするとjsのみ返す
     * @return mixed|void
     */
    public function delete($blockId, $isConfirm = false, $scriptOnly = false)
    {
        if ($isConfirm) {
            return;
        }
        $script = "javascript:{$this->mbObjName}.deleteBlock('{$blockId}');return false;";
        if ($scriptOnly) {
            return $script;
        } else {
            echo $this->Form->button('ブロックを削除', ['onclick' => $script, "type" => "button", 'class' => 'btn btn-danger btn-sm']);
        }
    }

    /**
     * entityオブジェクトの配列をソートする
     * 配列のキーは変更されないようにする
     */
    private function _sort(array $datas, array $sort)
    {
        // 配列要素が1つ以下の場合ソート必要なし
        if (count($datas) <= 1) {
            return $datas;
        }

        // $sortからソート対象のpropertyとソート方向を取得
        $field = $order = null;
        foreach ($sort as $key => $val) {
            $field = $key;
            $order = strtolower($val);
            break;
        }
        if (empty($field) || empty($order) || (!empty($order) && !in_array($order, ['asc', 'desc']))) {
            return false;
        }

        // sort対象の要素のみキーそのままで取り出す
        $targets = [];
        foreach ($datas as $key => $val) {
            $entity = $datas[$key];
            if (!isset($entity->{$field})) {
                // 該当のソートができない場合そのまま返す
                return $datas;
            }
            $targets[$key] = $entity->{$field};
        }

        // sort
        ($order == 'asc') ? asort($targets) : arsort($targets);

        // targetsのキーの順に$datasの要素を取り出す
        $ret = [];
        foreach (array_keys($targets) as $k) {
            $ret[$k] = $datas[$k];
        }

        return $ret;
    }

}