<?php
/**
 * ImageUploaderHelper
 * このアプリ独自の共通ヘルパー
 * @author ueno
 *
 */
class ImageUploaderHelper extends AppHelper {

	public $helpers = array('Html', 'Form', 'Cbase.Private', 'Cbase.Cform', 'Cbase.Minify');

	/**
	 * 画像アップロードフォーム
	 * Cform->imageFileAjaxのラッパーというか模倣
	 * 確認画面はもはや想定していない
	 */
	public function input($fieldName, $options = array(), $size = array(160, 120)) {
		$ret = '';

		// model, key, field取得, "ModelName.fieldName" or "ModelName.ID.fieldName"
		$model = $key = $field = '';
		$entity = explode('.', $fieldName);
		$entCnt = count($entity);
		if ($entCnt <= 1 || $entCnt >= 4) return '';
		$model = $entity[0];
		if ($entCnt == 3) {
			$key = $entity[1];
			$field = $entity[2];
		} elseif ($entCnt == 2) {
			$field = $entity[1];
		}

		// input type fileのID取得
		$id = !empty($options['id']) ? $options['id'] : $this->_cameled($fieldName);
		// 表示エリアのid
		$photoAreaSel = "photoArea_{$id}";

		// 画像アップjs
		$ret .= $this->_View->element('ImageUploader.image_uploader_js', array(
			'fieldName' => $fieldName,
			'model' => $model,
			'key' => $key,
			'field' => $field,
			'fileSel' => "#{$id}",
			'photoAreaSel' => "#{$photoAreaSel}",
			'size' => $size
		));

		$ret .= "<div id='{$photoAreaSel}'></div>";
		$ret .= $this->Form->file($fieldName, $options);
		return $ret;
	}

	/**
	 * Field名をIDのキャメルに変換
	 *
	 * @param string $fieldName
	 * @return string
	 */
	private function _cameled($fieldName){
		$names = explode('.', $fieldName);
		$cameled = '';
		foreach($names as $name){
			$cameled .= Inflector::camelize($name);
		}

		return $cameled;
	}

}