<?php
	// 以下の変数が必要
	// $fieldName
	// $tableName
	// $fileSel
	// $fileAreaSel

	// ajax uploadするURL
	$enc = urlencode($fieldName);
	$uploadUrl = $this->Url->build("/cbase/uploader/upload/{$tableName}/{$enc}");
?>

<?php $this->Html->scriptStart(['block' => false]); ?>
	<?php $this->Minify->scriptStart(); ?>
		jQuery(function($){
			var fieldName = '<?php echo $fieldName; ?>';
			var fileSel = '<?php echo $fileSel; ?>';
			var fileAreaSel = '<?php echo $fileAreaSel; ?>';
			var uploadUrl = '<?php echo $uploadUrl; ?>';
			var loader = '<?php echo $this->Html->image('/cbase/js/nupload/ajax-loader.gif'); ?>';

			// 写真が選択されたときにリサイズ
			$(document).on('change', fileSel, function(){
				// ファイルがない場合なにもしない
				if (this.files.length <= 0) {
					return;
				}
				var that = this;
				var fileObj = $(this);
				var fileAreaObj = $(this).prev(fileAreaSel);

				fileAreaObj.html(loader);
				// submitされないように全てのボタンはdisable
				$('.btn').attr('disabled', true);

				// ajaxでファイルのみPOST
				var fd = new FormData();
				var name = fieldName + '_file';
				var files = that.files;
				$.each(files, function(i, file){
					fd.append(name, file);
				});
				$.ajax({
					url: uploadUrl,
					type: 'POST',
					data: fd,
					contentType: false,
					processData: false,
					cache : false,
					success: function(html){
						fileAreaObj.html(html);
						// input type fileを空にするため置き換え
						fileObj.replaceWith(fileObj.clone(true));
						fileObj.val('');
						$('.btn').attr('disabled', false);
					},
					error: function(obj, error){
						fileAreaObj.html('');
						$('.btn').attr('disabled', false);
					}
				});

			});

			// 画像削除処理
			$(document).on('click', '.resizeAjaxFileDelBtn', function(){
				var container = $(this).closest(fileAreaSel);
				var fileInput = container.next('input:file');
				container.html('<?php echo $this->Form->hidden("{$fieldName}_shouldDelete", ['value' => true]); ?>');
				fileInput.replaceWith(fileInput = fileInput.clone(true));
				return false;
			});

		});
	<?php $this->Minify->scriptEnd(); ?>
<?php echo $this->Html->scriptEnd(); ?>
