<?php
namespace Cbase\View\Helper;
use Cake\View\Helper;
use Cake\View\View;
use Cake\Core\Configure;
use Cake\ORM\TableRegistry;
use Cake\Utility\Inflector;
use Cake\View\Form\NullContext;
use Cake\I18n\Date;
use Cake\I18n\Time;
use Cake\Utility\Hash;
/**
 * MultiIMageHelper
 *
 * @author ueno
 *
 * @property HtmlHelper $Html
 * @property FormHelper $Form
 */
class MultiImageHelper extends Helper
{

    /**
     * @var array helpers
     */
    public $helpers = ['Form', 'Html', 'Cbase.Minify'];

    /**
     * n段を表示
     * @param string $tableName テーブル名 SpotImages
     * @param string $imageField 画像フィールド
     * @param string $altField alt用フィールド nullにすると入力がなくなる
     * @param array|null $datas 初期表示させるデータ // entityの配列
     * @param boolean $isConfirm 確認画面の場合trueにする,trueにするとボタンや並び替えが非表示になる
     * @param array $options
     *      array $sort どの順番で表示するか ['sequence' => 'asc']
     */
    public function show($tableName, $imageField, $altField = null, $datas = [], $isConfirm = false, array $options = [])
    {
        $defaults = [
            'sort' => ['sequence' => 'asc']
        ];
        $options = array_merge($defaults, $options);

        // tableNameはunderscoreに
        $tableName = Inflector::underscore($tableName);
        // sequenceField
        $sequenceField = '';
        foreach ($options['sort'] as $key => $val) {
            $sequenceField = $key;
            break;
        }

        // 設定値(同一ページで複数のmultiblockができるようにユニークに)
        $uid = uniqid();
        // list area class name
        $wrapperClass = "multiImage_wrapper_{$uid}";
        // templateid
        $templateId = "multiImage_template_{$uid}";

        // 出力文字列
        $ret = '';
        $ret .= $this->Html->css('/cbase/js/nupload/nupload', ['block' => true]);

        // 入力画面のみ
        if (!$isConfirm) {
            // js読み込み
            $ret .= $this->Html->script('/cbase/js/nupload/jquery.dragsort-0.6', ['block' => true]);

            // 複製用のテンプレート
            $ret .= "<div id='{$templateId}' style='display: none;'>";
            $ret .= $this->_View->element('Cbase.multi_image', [
                'key' => 'NNN',
                'tableName' => $tableName,
                'imageField' => $imageField,
                'altField' => $altField,
                'sequenceField' => $sequenceField,
            ]);
            $ret .= '</div>';

            // upload input file
            $entity = $this->_View->get('formEntity');
            $parentTableName = $entity->source();
            $ret .= $this->_View->element('Cbase.multi_image_js', [
                'parentTableName' => $parentTableName,
                'childTableName' => $tableName,
                'imageField' => $imageField,
                'wrapperClass' => $wrapperClass,
                'templateId' => $templateId,
            ]);
        } else {
            // 確認画面では削除ボタンを消しておく
            $ret .= $this->Html->scriptBlock($this->Minify->scriptBlock("
                jQuery(function($){
                    $('.nBlockClose').remove();
                });
            "), ['block' => true]);
        }

        // メイン部分
        $ret .= "<div class='nWrapper {$wrapperClass}'><ul>";
        // 値をループして持ち回す
        if (!empty($datas)) {
            if (!empty($options['sort'])) {
                $datas = $this->_sort($datas, $options['sort']);
            }
            foreach ($datas as $key => $val) {
                if ($key === 'NNN') {
                    continue; //型まで比較
                }
                $ret .= "<li id='{$key}'><div>";
                $ret .= $this->_View->element('Cbase.multi_image', [
                    'key' => $key,
                    'tableName' => $tableName,
                    'imageField' => $imageField,
                    'altField' => $altField,
                    'sequenceField' => $sequenceField,
                ]);
                $ret .= '</div></li>';
            }
        }
        $ret .= '</ul></div>';

        echo $ret;

    }

    /**
     * entityオブジェクトの配列をソートする
     * 配列のキーは変更されないようにする
     */
    private function _sort(array $datas, array $sort)
    {
        // 配列要素が1つ以下の場合ソート必要なし
        if (count($datas) <= 1) {
            return $datas;
        }

        // $sortからソート対象のpropertyとソート方向を取得
        $field = $order = null;
        foreach ($sort as $key => $val) {
            $field = $key;
            $order = strtolower($val);
            break;
        }
        if (empty($field) || empty($order) || (!empty($order) && !in_array($order, ['asc', 'desc']))) {
            return false;
        }

        // sort対象の要素のみキーそのままで取り出す
        $targets = [];
        foreach ($datas as $key => $val) {
            $entity = $datas[$key];
            if (!isset($entity->{$field})) {
                // 該当のソートができない場合そのまま返す
                return $datas;
            }
            $targets[$key] = $entity->{$field};
        }

        // sort
        ($order == 'asc') ? asort($targets) : arsort($targets);

        // targetsのキーの順に$datasの要素を取り出す
        $ret = [];
        foreach (array_keys($targets) as $k) {
            $ret[$k] = $datas[$k];
        }

        return $ret;
    }

}